catch {destroy .app1}
toplevel .app1

frame .app1.f1 -borderwidth 10

# this must be set by scilab  - updated later by slider
if {! [info exist dbg_mode ]} {
    set sci_mode [llength [info commands ScilabEval]]
    set dbg_mode [expr ! $sci_mode ]
}

# ------------------------------------------------------
# variables for debug - standalone mode

if {$dbg_mode} {
# this must be set by scilab
console show
set C_N0 20.0
}


# this must be set by scilab
# global variables read by scilab even without C_N widget
set C_N $C_N0
set AWGN_flag 0

set dir [pwd]
puts "pwd=$dir"
set filenamestr [info script]
puts "filenamestr=$filenamestr"
set path [ file dirname $filenamestr]
puts "path=$path"


proc change_state {} {
    uplevel {
        if  { $button_state == {state_STOP} } {
            set button_state state_RUN
            .app1.f1.b1 configure -text "STOP" -bg red
        } else {
            set button_state state_STOP
            .app1.f1.b1 configure -text "RUN" -bg green
        }
        puts "button_state = $button_state \n"
    }
}

set button_state state_STOP
button .app1.f1.b1 -text "RUN" -bg green -command { change_state } -width 10
pack .app1.f1    -side top
pack .app1.f1.b1 -anchor center

frame .app1.f2 -borderwidth 10

radiobutton .app1.f2.r0 -text "N=1024"  -variable Nopt -value 1024
radiobutton .app1.f2.r1 -text "N=512"   -variable Nopt -value 512
radiobutton .app1.f2.r2 -text "N=256"   -variable Nopt -value 256
radiobutton .app1.f2.r3 -text "N=128"   -variable Nopt -value 128
radiobutton .app1.f2.r4 -text "N= 64"   -variable Nopt -value  64
radiobutton .app1.f2.r5 -text "N= 32"    -variable Nopt -value 32

set Nopt 128

pack .app1.f2 -side left
pack .app1.f2.r0 .app1.f2.r1 .app1.f2.r2 .app1.f2.r3 .app1.f2.r4 .app1.f2.r5 -anchor w -padx 3 -pady 3


frame .app1.f3 -borderwidth 10
button .app1.f3.b0 -text "Fig"  -width 10 -command { source "$path\\tk_Fig_v1.tcl" }
button .app1.f3.b1 -text "C/N"  -width 10 -command { source "$path\\tk_CN_slider_v1.tcl" }
button .app1.f3.b2 -text "PM"   -width 10 -command { source "$path\\tk_PM_slider_v1.tcl" }
button .app1.f3.b3 -text "BER"  -width 10 -command { source "$path\\tk_BER_v1.tcl" }
button .app1.f3.b4 -text "MER"  -width 10 -command { source "$path\\tk_MER_C_N_v1.tcl" }
button .app1.f3.b5 -text "RMS"  -width 10 -command { source "$path\\tk_RMS4_v1.tcl" }
button .app1.f3.b6 -text "FFT"  -width 10 -command { source "$path\\tk_FFT_v1.tcl" }

pack .app1.f3 -side left
pack   .app1.f3.b0 .app1.f3.b1 .app1.f3.b2 .app1.f3.b3 .app1.f3.b4 .app1.f3.b5 .app1.f3.b6 -padx 3 -pady 3



