catch {destroy .app3}
toplevel .app3

frame .app3.f1 -borderwidth 10

# this must be set by scilab  - updated later by slider
if {! [info exist dbg_mode ]} {
    set sci_mode [llength [info commands ScilabEval]]
    set dbg_mode [expr ! $sci_mode ]
}

# ------------------------------------------------------
# variables for debug - standalone mode

if {$dbg_mode} {
# this must be set by scilab
console show
set Nopt 4
set C_N0 20.0

}


# this must be set by scilab
# global variables read by scilab even without C_N widget
set C_N $C_N0
set AWGN_flag 0


set dir [pwd]
puts "pwd=$dir"
set filenamestr [info script]
puts "filenamestr=$filenamestr"
set path [ file dirname $filenamestr]
puts "path=$path"


proc change_state {} {
    uplevel {
        if  { $button_state == {state_STOP} } {
            set button_state state_RUN
            .app3.f1.b1 configure -text "STOP" -bg red
        } else {
            set button_state state_STOP
            .app3.f1.b1 configure -text "RUN" -bg green
        }
        puts "button_state = $button_state \n"
    }
}

set button_state state_STOP
button .app3.f1.b1 -text "RUN" -bg green -command { change_state } -width 10
pack .app3.f1    -side top
pack .app3.f1.b1 -anchor center

frame .app3.f2 -borderwidth 10

radiobutton .app3.f2.r0 -text "N=32"    -variable Nopt -value 32
radiobutton .app3.f2.r1 -text "N=16"    -variable Nopt -value 16
radiobutton .app3.f2.r2 -text "N=8" -variable Nopt -value 8
radiobutton .app3.f2.r3 -text "N=4" -variable Nopt -value 4
radiobutton .app3.f2.r4 -text "N=2" -variable Nopt -value  2
radiobutton .app3.f2.r5 -text "N=1"  -variable Nopt -value 1


pack .app3.f2 -side left
pack .app3.f2.r0 .app3.f2.r1 .app3.f2.r2 .app3.f2.r3 .app3.f2.r4 .app3.f2.r5 -anchor w -padx 3 -pady 3

# master - .app0
# slave windows
# C_N slider - .cn1
# BER - .ber1
# MER - .mer1
# RMS - .rms1
# FFT - .fft1

frame .app3.f3 -borderwidth 10
button .app3.f3.b0 -text "Fig"  -width 10  -command { source "$path\\tk_Fig_v1.tcl" }
button .app3.f3.b1 -text "C/N"  -width 10 -command { source "$path\\tk_CN_slider_v1.tcl" }
button .app3.f3.b2 -text "PM"   -width 10 ;# -command { source "$path\\tk_PM_slider_v1.tcl" }
button .app3.f3.b3 -text "MER"  -width 10 -command { source "$path\\tk_MER_v1.tcl" }
button .app3.f3.b4 -text "RMS"  -width 10 -command { source "$path\\tk_RMS4_v1.tcl" }
button .app3.f3.b5 -text "BER"  -width 10 -command { source "$path\\tk_BER_v1.tcl" }

pack .app3.f3 -side left
pack   .app3.f3.b0 .app3.f3.b1 .app3.f3.b2 .app3.f3.b3 .app3.f3.b4 .app3.f3.b5 -padx 3 -pady 3



