# Simple interface to launch basic dialogue for start-up configuration
# -----------------------------------------------
# Use of a namespace makes things easier

# debug variables for standalone
if {! [info exist dbg_mode ]} {
    set sci_mode [llength [info commands ScilabEval]]
    set dbg_mode [expr ! $sci_mode ]
}

# ------------------------------------------------------
# variables for debug - standalone mode

if {$dbg_mode} {
 console show
 namespace eval ::tkGetConf {}
 set ::tkGetConf::FileName {./conf_64QPSK_def.cfg}
 set ::tkGetConf::Dir      {./}
 puts "TCL_tkGetConf_DBG>> debug mode "
} else {
 puts "TCL_tkGetConf_DBG>> Scilab mode "
}

namespace eval ::tkGetConf {

    puts {TCL_tkGetConf_DBG>>::tkGetConf Inint script}

    set LabelWidth 50

    set ::tkGetConf::types {
      {"Config files" {.cfg} }
      {"All files"   *      }
    }


    proc TrimFileName {str strlen} {

        if {[string length $str] <= $strlen }  {
            return $str
        } else {
            # this is a command of the type:
            #  set y [set x 0][incr x][incr x]
            #  which always gives 012
            # so this is "..." prefix -> actual label width is larger to accommodate this

            return [set x {...}][string range $str end-[expr $strlen-1] end ]
        }
    }



    set TrimedFileName [TrimFileName $::tkGetConf::FileName $::tkGetConf::LabelWidth]
    if {[info exist result]} {
        unset result
        puts {TCL_tkGetConf_DBG>> Variable ::tkGetConf::result deleted}
    }


    set win .tkGetConf
    catch {destroy $win}
    toplevel $win

    puts "TCL_tkGetConf_DBG>> $win created "

    bind $win <Destroy> {
         # set ::tkGetConf::result $::tkGetConf::FileName
         puts "TCL_tkGetConf_DBG>> win destroyed - no variable exist so no ref!"
    }

    labelframe $win.lf -text "FileName"
    label $win.lf.labFile -background white -width [expr $LabelWidth+4] \
    -anchor w \
    -textvariable ::tkGetConf::TrimedFileName


    pack $win.lf.labFile -padx 5 -pady 5
    pack $win.lf

    button $win.buttNew -text "New" \
    -command {
        set NewFileName \
        [tk_getOpenFile -initialdir $::tkGetConf::Dir -filetypes $::tkGetConf::types]
        if { $NewFileName != "" } {
             set ::tkGetConf::FileName $NewFileName
             set ::tkGetConf::TrimedFileName \
            [::tkGetConf::TrimFileName $::tkGetConf::FileName $::tkGetConf::LabelWidth]
        }
    }

    button $win.buttGo -text "Go" \
    -command {
        puts "TCL_tkGetConf_DBG>> GO  result = $::tkGetConf::FileName "
        set ::tkGetConf::result $::tkGetConf::FileName
    }
    pack $win.buttGo $win.buttNew -side right -padx 5 -pady 5

    puts {TCL_tkGetConf_DBG>> end of script reached }
}
