funcprot(0);
// c++ compatible assert function - for x==y you get vector - thus and() 
function itpp_sci_assert( bool_cond_vector, str_msg)
    if ~(and(bool_cond_vector)) then
        disp (str_msg);
        halt;
    end
endfunction

// this function converts vec into cvec
function z = to_cvec(x,y) 
 z=x+%i*y;
endfunction


// this function converts vec into bvec
function b = to_bvec(x) 
 b=(x(:) <> 0);
endfunction

// this function converts vec into bvec
function b = to_bmat(x) 
 b=(x(:,:) <> 0);
endfunction

// this function converts bvec into vec
function v = to_vec(b) 
 v=bool2s(b);
endfunction

// this function converts bmat into mat
function m = to_mat(b) 
 m=bool2s(b);
endfunction

// this function converts matrix into vec
function v = rvectorize(m) 
 [r,c]=size(m);
 // matrix does it columnwise - try transpose to make it rowwise
 v=matrix(m',r*c,1);
endfunction

// this function gives CE_1 of size v
function ce1 = CE_1(v) 
 n=max(size(v));
 ce1(1:n,1)=%T;
endfunction

// this function gives CE_0 of size v
function ce0 = CE_0(v) 
 n=max(size(v));
 ce0(1:n,1)=%F;
endfunction


// this function converts uint32 into vector of bits 0/1
function b = bitvect32(x) 

    p=32;
    if x>=2^p then error('Bitvect32 - Dimension');
    end
    for i = 1:p
      b(i,1) = pmodulo(x,2);
      x = floor (x ./ 2);
    end
endfunction

// this function converts hex(32bit)  into vector of bits 0/1
function b = BitVectHex(hex) 
   b=bitvect32(uint32(sscanf(hex,"%x")));   
endfunction

// this function converts i to boolean matrix of 32 bits
function bb = int2bool(i) 
  bx=bitvect32(i);   
  bb=(bx(:)==1)
endfunction

// this function converts i to boolean matrix of L bits - bb(1)<=>2^0
function bb = rev_dec2bin(L,i) 
  b=bitvect32(i);   
  bb=(b(1:L)==1)
endfunction

// this function converts i to boolean matrix of L bits - bb(1)<=>2^L-1
function bx = dec2bin(L,i) 
  b=bitvect32(i);   
  bx(1:L)=(b(L:-1:1)==1)
endfunction

// 
function z = xor(x,y) 
  z=((~x)&y)|(x&(~y));     
endfunction

function y=reverse_row(x)
    y=flipdim(x,2);
endfunction

function y=reverse_col(x)
    y=flipdim(x,1);
endfunction
