//! test scilab_itpp with fir
//---------------------------

path=get_absolute_file_path("sci_fir1.sce");
chdir(path);
pwd;
//---------------------------
if (~ exists('ITPP_SCI_LIB'))
  clear;
  clc;
  lines(0);
  dbg=0;
  exec("..\..\lib\sci_api1.sci");
  exec("..\..\lib\sci_func1.sci");  
end
//---------------------------

N=10;
TAPS = 5;
i=1:N;
c0=ones(TAPS,1)*0.1;
x=zeros(N,1);
x(1,1)=1.0;
ce(1:N,1)=%t;

p_fir1=SCI_CREATE(SCI_FIR);
sci_type = SCI_GET(p_fir1, SCI_TYPE);
itpp_sci_assert(sci_type == SCI_FIR, "type != SCI_FIR");
SCI_SET(p_fir1,SCI_TAPS,c0);
SCI_EXEC(p_fir1,SCI_RESET);
c1 = SCI_GET(p_fir1, SCI_TAPS);
z1 = SCI_GET(p_fir1, SCI_STATE);
itpp_sci_assert(c1 == c0, "c1 != c0");
itpp_sci_assert(z1 == zeros(TAPS,1), "z1 != zeros(TAPS,1)");
y=SCI_PROC(p_fir1,ce,x);
yref = [c0; zeros(N - TAPS,1)]; 
itpp_sci_assert(y == yref, "y != yref");
SCI_DESTROY(p_fir1);

//---------------------------
if (~ exists('ITPP_SCI_LIB'))
    ulink(id);
    printf('So, this is it \n');
end
//---------------------------
