//! test scilab_itpp with lsr
//---------------------------

path=get_absolute_file_path("sci_lsr1.sce");
chdir(path);
pwd;
//---------------------------
if (~ exists('ITPP_SCI_LIB'))
  clear;
  clc;
  lines(0);
  dbg=0;
  exec("..\..\lib\sci_api1.sci");
  exec("..\..\lib\sci_func1.sci");  
end
//---------------------------
// Symbol size
W = 4;
// LSR FIFO lenght in symbols  
D = 3;
// ----------------------------------
// set LSR memory lenght 
L = D*W;
// clock ticks  
N = 2 * D;
// test paterns by prbs generator 2^4-1	
PRBS = 4;

p_lfsr1 = SCI_CREATE(SCI_LFSR);
sci_type = SCI_GET(p_lfsr1, SCI_TYPE);
itpp_sci_assert(sci_type == SCI_LFSR, "sci_type != SCI_LFSR");

p_lsr1 = SCI_CREATE(SCI_LSR);
sci_type = SCI_GET(p_lsr1, SCI_TYPE);
itpp_sci_assert(sci_type == SCI_LSR, "sci_type != SCI_LSR");

// set length and symbol_size as minimal setup
SCI_SET(p_lsr1, SCI_LENGTH, L);
SCI_SET(p_lsr1, SCI_SYMBOL_SIZE, W);
T = SCI_GET(p_lsr1, SCI_LENGTH);
itpp_sci_assert(T == L, "T != L");
T = SCI_GET(p_lsr1, SCI_SYMBOL_SIZE);
itpp_sci_assert(T == W, "T != W");

// set LFSR as prbs generator
SCI_SET(p_lfsr1, SCI_PRBS, PRBS);
SCI_SET(p_lfsr1, SCI_SYMBOL_SIZE, W);

// generate ce 
ce(1:N)=%T;
// generate symbols
x = SCI_GEN(p_lfsr1, ce);
x_ref = to_bmat([1 1 0 0; 1 0 1 0; 0 1 1 1; 0 1 0 0; 0 1 1 0; 1 1 0 1]);
ce_ref = to_bvec([1 1 1 1 1 1]);
y_ref = to_bmat([0 0 0 0; 0 0 0 0; 0 0 0 0; 1 1 0 0; 1 0 1 0; 0 1 1 1]);
itpp_sci_assert(x == x_ref, "x != x_ref");
itpp_sci_assert(ce == ce_ref, "ce != ce_ref");
y = SCI_PROC(p_lsr1, ce, x);
itpp_sci_assert(y == y_ref, "y != y_ref");

SCI_DESTROY(p_lfsr1);
SCI_DESTROY(p_lsr1);

//---------------------------
if (~ exists('ITPP_SCI_LIB'))
    ulink(id);
    printf('So, this is it \n');
end
//---------------------------

