//! test scilab with bert
//---------------------------
path=get_absolute_file_path("sci_bert1.sce");
chdir(path);
pwd;

//---------------------------
if (~ exists('ITPP_SCI_LIB'))
  clear;
  clc;
  lines(0);
  dbg=0;
  exec("..\..\lib\sci_api1.sci");
  exec("..\..\lib\sci_func1.sci");  
end

//---------------------------
// Symbol size QPSK
W = 2;
// test patterns by prbs generator M=2^PRBS-1	
PRBS = 4;
// BERT correlator - number of symbols 
N = 10;
// BERT correlator length       
L = W*N;
// T= [T0, T1, T2] - SYNC for metrics < T1 i.e. BER < 4/20 (more than 1.0E-1); 
T = [2 4 8].';

one = to_bvec([1]);
p_prbs1 = SCI_CREATE(SCI_LFSR);
sci_type = SCI_GET(p_prbs1, SCI_TYPE);
itpp_sci_assert(sci_type == SCI_LFSR, "sci_type != SCI_LFSR");

p_bert1 = SCI_CREATE(SCI_BERT);
sci_type = SCI_GET(p_bert1, SCI_TYPE);
itpp_sci_assert(sci_type == SCI_BERT, "sci_type != SCI_BERT");
// set LFSR as prbs generator
SCI_SET(p_prbs1, SCI_PRBS, PRBS);
SCI_SET(p_prbs1, SCI_SYMBOL_SIZE, W);
// set BERT prbs generator
SCI_SET(p_bert1, SCI_PRBS, PRBS);	
// L must be set first - symbol_size <= L
SCI_SET(p_bert1, SCI_LENGTH, L);
SCI_SET(p_bert1, SCI_SYMBOL_SIZE, W);
SCI_SET(p_bert1, SCI_THRESHOLD, T);
// set initiation state
SCI_SET(p_bert1, SCI_FSM, BERT_FSM_RELOAD);

// number of symbols to transition from RELOAD->PRESET
K_RELOAD = int(SCI_GET(p_prbs1, SCI_LENGTH) / W);
for (k = 1:K_RELOAD)
    p = SCI_GEN(p_prbs1, one);
    state = SCI_PROC(p_bert1, one, p);
    SCI_SET(p_bert1, SCI_ADR, BERT_ADR_LSRX);
    x = SCI_GET(p_bert1, SCI_STATE);
    SCI_SET(p_bert1, SCI_ADR, BERT_ADR_LSRY);
    y = SCI_GET(p_bert1, SCI_STATE);
    SCI_SET(p_bert1, SCI_ADR, BERT_ADR_PRBS);
    z = SCI_GET(p_bert1, SCI_STATE);
    fsm = SCI_GET(p_bert1, SCI_FSM);
    z1 = SCI_GET(p_prbs1, SCI_STATE);
end
x_ref = to_bvec([1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0]);
y_ref = to_bvec([0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0]);
z_ref = to_bvec([0 0 1 1]);

itpp_sci_assert(x == x_ref, "x!=x_ref");
itpp_sci_assert(y == y_ref, "y!=y_ref");
itpp_sci_assert(z == z_ref, "z!=z_ref");
itpp_sci_assert(fsm == BERT_FSM_PRESET, "fsm != BERT_FSM_PRESET");

// number of symbols to transition from RELOAD->PRESET
K_PRESET = int(SCI_GET(p_bert1, SCI_LENGTH) / W);
for (k = 1:K_PRESET)
    p = SCI_GEN(p_prbs1, one);
    state = SCI_PROC(p_bert1, one, p);
    SCI_SET(p_bert1, SCI_ADR, BERT_ADR_LSRX);
    x = SCI_GET(p_bert1, SCI_STATE);
    SCI_SET(p_bert1, SCI_ADR, BERT_ADR_LSRY);
    y = SCI_GET(p_bert1, SCI_STATE);
    SCI_SET(p_bert1, SCI_ADR, BERT_ADR_PRBS);
    z = SCI_GET(p_bert1, SCI_STATE);
    fsm = SCI_GET(p_bert1, SCI_FSM);
    z1 = SCI_GET(p_prbs1, SCI_STATE);
end
x_ref = to_bvec([1 1 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 0 1 0]);
y_ref = to_bvec([1 1 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 0 1 0]);
z_ref = to_bvec([1 0 1 1]);
itpp_sci_assert(x == x_ref, "x!=x_ref");
itpp_sci_assert(y == y_ref, "y!=y_ref");
itpp_sci_assert(z == z_ref, "z!=z_ref");
itpp_sci_assert(fsm == BERT_FSM_SYNC, "fsm != BERT_FSM_SYNC");

acc_cnt = SCI_GET(p_bert1, SCI_ACC_CNT);
cnt = SCI_GET(p_bert1, SCI_CNT);
acc_cnt_ref = [0 0].';
cnt_ref = [0 0].';
itpp_sci_assert(cnt == cnt_ref, "cnt != cnt_ref");
itpp_sci_assert(acc_cnt == acc_cnt_ref, "acc_cnt != acc_cnt_ref");

// test BER	
K = 10;
ce(1:K) = %T;
pmat = SCI_GEN(p_prbs1, ce); // must generate continously - this is what bert expects
SCI_PROC(p_bert1, ce, pmat);
acc_cnt = SCI_GET(p_bert1, SCI_ACC_CNT);
cnt = SCI_GET(p_bert1, SCI_CNT);
acc_cnt_ref = [0 20].';
cnt_ref = [0 20].';
itpp_sci_assert(cnt == cnt_ref, "cnt != cnt_ref");
itpp_sci_assert(acc_cnt == acc_cnt_ref, "acc_cnt != acc_cnt_ref");
itpp_sci_assert(fsm == BERT_FSM_SYNC, "fsm != BERT_FSM_SYNC");

// make one err 
errmat(K, W)=%F;
errmat(1, 1) = %T;
pmat = SCI_GEN(p_prbs1, ce); // must generate continously - this is what bert expects
// pmat=xor(pmat,errmat)
// xor(x,y)=x*(/y)+(/x)*y
pmat = (pmat & (~errmat))|((~pmat) & (errmat));
SCI_PROC(p_bert1, ce, pmat);

acc_cnt = SCI_GET(p_bert1, SCI_ACC_CNT);
cnt = SCI_GET(p_bert1, SCI_CNT);
acc_cnt_ref = [1 40].';
cnt_ref = [1 20].';
itpp_sci_assert(cnt == cnt_ref, "cnt != cnt_ref");
itpp_sci_assert(acc_cnt == acc_cnt_ref, "acc_cnt != acc_cnt_ref");
itpp_sci_assert(fsm == BERT_FSM_SYNC, "fsm != BERT_FSM_SYNC");

SCI_DESTROY(p_prbs1);
SCI_DESTROY(p_bert1);

//---------------------------
if (~ exists('ITPP_SCI_LIB'))
    ulink(id);
    printf('So, this is it \n');
end
//---------------------------

