//!  test scilab_itpp with qam_mod, qam_dem
//---------------------------

path=get_absolute_file_path("sci_qam1.sce");
chdir(path);
pwd
//---------------------------
if (~ exists('ITPP_SCI_LIB'))
  clear;
  clc;
  lines(0);
  dbg=0;
  exec("..\..\lib\sci_api1.sci");
  exec("..\..\lib\sci_func1.sci");  
end
//---------------------------


M = 4;
p_qmod1 = SCI_CREATE(SCI_QAM_MOD);
sci_type = SCI_GET(p_qmod1, SCI_TYPE);
itpp_sci_assert(sci_type == SCI_QAM_MOD, "sci_type != SCI_QAM_MOD");

p_qdem1 = SCI_CREATE(SCI_QAM_DEM);
sci_type = SCI_GET(p_qdem1, SCI_TYPE);
itpp_sci_assert(sci_type == SCI_QAM_DEM, "sci_type != SCI_QAM_DEM");

SCI_SET(p_qmod1, SCI_SIZE, M);
m = SCI_GET(p_qmod1, SCI_SIZE);
itpp_sci_assert(m == M, "m != M");

SCI_SET(p_qdem1, SCI_SIZE, M);
m = SCI_GET(p_qdem1, SCI_SIZE);
itpp_sci_assert(m == M, "m != M");

ivx = [0; 1; 2; 3];
cv_ref = [0.50000+0.50000*%i; -0.50000+0.50000*%i; 0.50000-0.50000*%i; -0.50000-0.50000*%i];
ivy_ref = ivx;
ce(1:M,1)=%t;

cv =  SCI_PROC(p_qmod1, ce, ivx);
ivy = SCI_PROC(p_qdem1, ce, cv); 

itpp_sci_assert(cv == cv_ref, "cv!=cv_ref");
itpp_sci_assert(ivy == ivy_ref, "ivy!=ivy_ref");

SCI_DESTROY(p_qmod1);
SCI_DESTROY(p_qdem1);


//---------------------------
if (~ exists('ITPP_SCI_LIB'))
    ulink(id);
    printf('So, this is it \n');
end
//---------------------------

