//! test c_sci qam interface
//---------------------------

path=get_absolute_file_path("sci_nco1.sce");
chdir(path);
pwd;
//---------------------------
if (~ exists('ITPP_SCI_LIB'))
  clear;
  clc;
  lines(0);
  dbg=0;
  exec("..\..\lib\sci_api1.sci");
  exec("..\..\lib\sci_func1.sci");  
end
//---------------------------

format('v',10);
// input is L/M  checked for cases 1/8; 2/9; -1/8; -2/9;
// 1/8 is an easy test; 
// 2/9 more complicated case - nco fails for L/M exactly 2/9  
// the ideal sequence looks like this below - vco produces a sequence with cy jitter 
//  [0][-2 / 9], [0][-4 / 9], [0][-6 / 9], [0][-8 / 9], [-1][-1 / 9],
//  [0][-3 / 9], [0][-5 / 9], [0][-7 / 9], [-1][0 / 9],
//  [0][-2 / 9], [0][-4 / 9], [0][-6 / 9], [0][-8 / 9], [-1][-1 / 9],
//  [0][-3 / 9], [0][-5 / 9], [0][-7 / 9], [-1][0 / 9],
// in nco - double fractional input x[i] is rounded during conversion to fixed point Q1.N and this might be a reason (or not?)...

L = -2.000001;
M = 9.0;
N = 3 * M;
Nq_bits = 60; // NCO phase accumulator format is Q1.Nq_bits
epsilon = 1.0E-6;

p_nco1 = SCI_CREATE(SCI_NCO);
sci_type = SCI_GET(p_nco1, SCI_TYPE);
itpp_sci_assert(sci_type == SCI_NCO, "sci_type != SCI_NCO");
SCI_SET(p_nco1, SCI_PARAM_N, Nq_bits);
itpp_sci_assert(SCI_GET(p_nco1, SCI_PARAM_N) == Nq_bits, "nco1.get_N() != Nq_bits");

p_vco1 = SCI_CREATE(SCI_VCO);
sci_type = SCI_GET(p_vco1, SCI_TYPE);
itpp_sci_assert(sci_type == SCI_VCO, "sci_type != SCI_VCO");

ce(1:N,1) = %T;
true_vec(1:N,1) = %T;
x(1:N,1) = (L/M);

nco_y = SCI_PROC(p_nco1, ce, x);
vco_y = SCI_PROC(p_vco1, ce, x);
//  cy - carry
cy_nco = to_bvec(nco_y(:,1));
cy_vco = to_bvec(vco_y(:,1));
itpp_sci_assert(cy_nco == cy_vco, "cy_nco != cy_vco");
// ph - phase
ph_nco = nco_y(:,2);
ph_vco = nco_y(:,2);
itpp_sci_assert((abs(ph_nco - ph_vco) < epsilon) == true_vec, "abs(nco_ph - vco_ph) > epsilon ");

SCI_DESTROY(p_nco1);
SCI_DESTROY(p_vco1);

//---------------------------
if (~ exists('ITPP_SCI_LIB'))
    ulink(id);
    printf('So, this is it \n');
end
//---------------------------
        
