//! test c_sci qam interface
//---------------------------
path=get_absolute_file_path("sci_ejp1.sce");
chdir(path);
pwd;

//---------------------------
if (~ exists('ITPP_SCI_LIB'))
  clear;
  clc;
  lines(0);
  dbg=0;
  exec("..\..\lib\sci_api1.sci");
  exec("..\..\lib\sci_func1.sci");  
end
//---------------------------


format('v',6);

L = 1.000;
M = 4.0;
N = 2 * M;
Nq_bits = 60;  // NCO phase accumulator format is Q1.Nq_bits
epsilon = 1.0E-6;

p_nco1 = SCI_CREATE(SCI_NCO);

p_ejp1 = SCI_CREATE(SCI_EJP);
sci_type = SCI_GET(p_ejp1, SCI_TYPE);
itpp_sci_assert(sci_type == SCI_EJP, "ejp1.sci_type != SCI_EJP");


SCI_SET(p_nco1, SCI_PARAM_N, Nq_bits);
itpp_sci_assert(SCI_GET(p_nco1, SCI_PARAM_N) == Nq_bits, "nco1.get_N() != Nq_bits");

ce(1:N,1)=%T;
x(1:N,1)=(L/M);
true_vec(1:N,1) = %T;

nco_y=SCI_PROC(p_nco1, ce, x);
nco_ph = nco_y(:,2);
ejp_y = SCI_PROC(p_ejp1, ce, nco_ph);
ejp_ref = cos(2 * %pi * nco_ph)+%i*sin(2 * %pi * nco_ph);
itpp_sci_assert((abs(real(ejp_y) - real(ejp_ref)) < epsilon) == true_vec, "abs(real(ejp_y) - real(ejp_ref)) > epsilon ");
itpp_sci_assert((abs(imag(ejp_y) - imag(ejp_ref)) < epsilon) == true_vec, "abs(imag(ejp_y) - imag(ejp_ref)) > epsilon ");

SCI_DESTROY(p_nco1);
SCI_DESTROY(p_ejp1);
format('v',10); 

//---------------------------
if (~ exists('ITPP_SCI_LIB'))
    ulink(id);
    printf('So, this is it \n');
end
//---------------------------
