//! test itpp_sci interface
//---------------------------

path=get_absolute_file_path("sci_circbuff_x1.sce");
chdir(path);
pwd;

//---------------------------
if (~ exists('ITPP_SCI_LIB'))
  clear;
  clc;
  lines(0);
  dbg=0;
  exec("..\..\lib\sci_api1.sci");
  exec("..\..\lib\sci_func1.sci");  
end
//---------------------------

M = 3;
N = 10;

a = (linspace(0, M-1, M)).'; // column vectors are returned by itpp_sci
b = (linspace(M, N-1, N-M)).';
ref = [a; b]; 

a_x = a + %i*zeros(M).';  // column vectors are returned by itpp_sci
b_x = b + %i*zeros(N-M).';
ref_x = [a_x; b_x]; 

null_vec = [];
null_cvec = [] + %i*[];


p_cb1 = SCI_CREATE(SCI_CIRCBUFF);
sci_type = SCI_GET(p_cb1, SCI_TYPE);
itpp_sci_assert(sci_type == SCI_CIRCBUFF, "sci_type != SCI_CIRCBUFF");
SCI_SET(p_cb1, SCI_SIZE, N);
itpp_sci_assert(SCI_GET(p_cb1, SCI_SIZE) == N, "cb1.get_size() != N");

p_cb_x1 = SCI_CREATE(SCI_CIRCBUFF_X);
sci_type = SCI_GET(p_cb_x1, SCI_TYPE);
itpp_sci_assert(sci_type == SCI_CIRCBUFF_X, "sci_type != SCI_CIRCBUFF_X");
SCI_SET(p_cb_x1, SCI_SIZE, N);
itpp_sci_assert(SCI_GET(p_cb_x1, SCI_SIZE) == N, "cb_x1.get_size() != N");

// put [a|b] , peek, rev_peek, get(), get(), get(), get(-1), get(-1)
SCI_SET(p_cb1, SCI_VEC, a);
SCI_SET(p_cb1, SCI_VEC, b);
out_vec = SCI_GET(p_cb1, SCI_PEEK_VEC);
itpp_sci_assert( out_vec == ref, "peek(out_vec) != ref");

out_vec = SCI_GET(p_cb1, SCI_PEEK_REV_VEC);
itpp_sci_assert( out_vec == reverse_col(ref), "peek_reverse(out_vec) != reverse(ref)");

v = SCI_GET(p_cb1, SCI_SINGLETON);
itpp_sci_assert(v == a(1), "v != a[1]");
v = SCI_GET(p_cb1, SCI_SINGLETON);
itpp_sci_assert(v == a(2), "v != a[2]");
v = SCI_GET(p_cb1, SCI_SINGLETON);
itpp_sci_assert(v == a(3), "v != a[3]");

out_vec = SCI_GET(p_cb1, SCI_VEC);
itpp_sci_assert( out_vec == b, "out_vec != b");

out_vec = SCI_GET(p_cb1, SCI_PEEK_VEC);
itpp_sci_assert( out_vec == null_vec, "out_vec != null_vec");

// process( M cei ticks), gen(N ticks)
cei(1:M,1) = %T;
ceo(1:M,1) = %F;
// combine ceio = [cei|cei]
ceio = [cei, ceo];

itpp_sci_assert(SCI_GET(p_cb1, SCI_N_OF_ELEM) == 0, "cb1.nrof_elements() != 0");

y = SCI_PROC(p_cb1, ceio, a);

itpp_sci_assert(y == zeros(M).', "y == zeros(M)");
itpp_sci_assert(SCI_GET(p_cb1, SCI_N_OF_ELEM) == M, "cb1.nrof_elements() != M");

cei(1:N,1) = %T;
y = SCI_GEN(p_cb1, cei);
ref = [a; a; a; a(1)];
itpp_sci_assert(y == ref, "y != ref");

// put [a|b] , peek, rev_peek, get(), get(), get(), get(-1), get(-1)
SCI_SET(p_cb_x1, SCI_VEC, a_x);
SCI_SET(p_cb_x1, SCI_VEC, b_x);
out_vec_x = SCI_GET(p_cb_x1, SCI_PEEK_VEC);
itpp_sci_assert( out_vec_x == ref_x, "peek(out_vec_x) != ref_x");

out_vec_x = SCI_GET(p_cb_x1, SCI_PEEK_REV_VEC);
itpp_sci_assert( out_vec_x == reverse_col(ref_x), "peek_reverse(out_vec) != reverse(ref)");

v_x = SCI_GET(p_cb_x1, SCI_SINGLETON);
itpp_sci_assert(v_x == a_x(1), "v_x != a_x[1]");
v_x = SCI_GET(p_cb_x1, SCI_SINGLETON);
itpp_sci_assert(v_x == a_x(2), "v_x != a_x[2]");
v_x = SCI_GET(p_cb_x1, SCI_SINGLETON);
itpp_sci_assert(v_x == a_x(3), "v_x != a_x[3]");

out_vec_x = SCI_GET(p_cb_x1, SCI_VEC);
itpp_sci_assert( out_vec_x == b_x, "out_vec_x != b_x");

out_vec_x = SCI_GET(p_cb_x1, SCI_PEEK_VEC);
itpp_sci_assert( out_vec_x == null_cvec, "out_vec_x != null_cvec");

// process(M cei ticks), gen(N ticks)
// reset to set shape again
cei = [];
ceo = [];
ceio = [];
cei(1:M,1) = %T;
ceo(1:M,1) = %F;
// combine ceio = [cei|cei]
ceio = [cei, ceo];

itpp_sci_assert(SCI_GET(p_cb_x1, SCI_N_OF_ELEM) == 0, "cb_x1.nrof_elements() != 0");

y_x = SCI_PROC(p_cb_x1, ceio, a_x);

itpp_sci_assert(y_x == zeros(M).', "y_x == zeros(M)");
itpp_sci_assert(SCI_GET(p_cb_x1, SCI_N_OF_ELEM) == M, "cb_x1.nrof_elements() != M");

cei(1:N,1) = %T;
y_x = SCI_GEN(p_cb_x1, cei);
ref_x = [a_x; a_x; a_x; a_x(1)];
itpp_sci_assert(y_x == ref_x, "y_x != ref_x");


SCI_DESTROY(p_cb1);
SCI_DESTROY(p_cb_x1);

//---------------------------
if (~ exists('ITPP_SCI_LIB'))
    ulink(id);
    printf('So, this is it \n');
end
//---------------------------
