//! test itpp_sci interface
//---------------------------

path=get_absolute_file_path("sci_cofdm1.sce");
chdir(path);
pwd;

//---------------------------
if (~ exists('ITPP_SCI_LIB'))
  clear;
  clc;
  lines(0);
  dbg=0;
  exec("..\..\lib\sci_api1.sci");
  exec("..\..\lib\sci_func1.sci");  
end
//---------------------------

format('v',6);

NFFT = 16; // Nfft 
CP = 8; 
M = 4;  // qpsk
epsilon = 1.0E-6;

p_cofdm_mod1 = SCI_CREATE(SCI_COFDM_MOD);
p_cofdm_dem1 = SCI_CREATE(SCI_COFDM_DEM);
p_cofdm_map1 = SCI_CREATE(SCI_COFDM_MAP);
p_cofdm_demap1 = SCI_CREATE(SCI_COFDM_DEMAP);
p_cofdm_sel1 = SCI_CREATE(SCI_COFDM_SEL);


// set modulator
SCI_SET(p_cofdm_mod1, SCI_COFDM_NFFT, NFFT);
SCI_SET(p_cofdm_mod1, SCI_COFDM_CP, CP);
// set demodulator
SCI_SET(p_cofdm_dem1, SCI_COFDM_NFFT, NFFT);
SCI_SET(p_cofdm_dem1, SCI_COFDM_CP, CP);
// set mapper 
SCI_SET(p_cofdm_map1, SCI_COFDM_NFFT, NFFT);
SCI_SET(p_cofdm_map1, SCI_COFDM_QAM_SIZE, M);
// set mapper 
SCI_SET(p_cofdm_demap1, SCI_COFDM_NFFT, NFFT);
SCI_SET(p_cofdm_demap1, SCI_COFDM_QAM_SIZE, M);
// set sel 
SCI_SET(p_cofdm_sel1, SCI_COFDM_NFFT, NFFT);
// z - zero carrier
// p - pilot carrier
// d - data carrier
// 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15
// z p d d d p d d d p d  d  d  p  d  z
dcindx = [ 2 3 4 6 7 8 10 11 12 14 ]; 
dc     = [ 0 1 2 3 0 1 2  3  0  1  ];
zcindx = [ 0 15 ];
pcindx = [ 1 5 9 13 ];
pc     = [ %F %T %F %T];
z_mod(1:2,1) = 0+%i*0;
true_vec(1:2,1) = %T;

// set data pilots zero carrier indexes for map
SCI_SET(p_cofdm_map1, SCI_COFDM_DATA_INDEXES, dcindx);
SCI_SET(p_cofdm_map1, SCI_COFDM_PILOT_INDEXES, pcindx);
SCI_SET(p_cofdm_map1, SCI_COFDM_ZERO_INDEXES, zcindx);
// set data pilots zero carrier indexes for demap
SCI_SET(p_cofdm_demap1, SCI_COFDM_DATA_INDEXES, dcindx);
SCI_SET(p_cofdm_demap1, SCI_COFDM_PILOT_INDEXES, pcindx);
SCI_SET(p_cofdm_demap1, SCI_COFDM_ZERO_INDEXES, zcindx);
// set data pilots zero carrier indexes for demap
SCI_SET(p_cofdm_sel1, SCI_COFDM_SEL_INDEXES, zcindx);

// map data/pilots into symbols
SCI_SET(p_cofdm_map1, SCI_COFDM_DATA, dc);
SCI_SET(p_cofdm_map1, SCI_COFDM_PILOTS, pc);
y_map = SCI_GET(p_cofdm_map1, SCI_COFDM_CARRIERS);
// modulate
SCI_SET(p_cofdm_mod1, SCI_COFDM_CARRIERS, y_map);
y_mod = SCI_GET(p_cofdm_mod1, SCI_COFDM_SYMBOL);

cp_lead = y_mod(1:CP);
cp_trail = y_mod(NFFT+1:NFFT+CP);
itpp_sci_assert(cp_lead == cp_trail, "cp_lead != cp_trail");

// demodulate
SCI_SET(p_cofdm_dem1, SCI_COFDM_SYMBOL, y_mod);
y_dem = SCI_GET(p_cofdm_dem1, SCI_COFDM_CARRIERS);
// demap
SCI_SET(p_cofdm_demap1, SCI_COFDM_CARRIERS, y_dem);
y_demap_data = SCI_GET(p_cofdm_demap1, SCI_COFDM_DATA).';
y_demap_pilots = SCI_GET(p_cofdm_demap1, SCI_COFDM_PILOTS).';

// select zero carriers
SCI_SET(p_cofdm_sel1, SCI_COFDM_CARRIERS, y_dem);
z_dem = SCI_GET(p_cofdm_sel1, SCI_COFDM_SEL_CARRIERS);

itpp_sci_assert(y_demap_data == dc, "y_demap_data != dc");
itpp_sci_assert(y_demap_pilots == pc, "y_demap_pilots != pc");
// itpp_sci_assert((abs(z_dem - z_mod) < epsilon) == true_vec, "z_dem != z_mod");

// test clocked interface with double tick
ce(1:2,1) = %T;
m_pd(1,:) = [reverse_row(to_vec(pc)), reverse_row(dc)];
m_pd(2,:) = [to_vec(pc), dc];

m_map = SCI_PROC(p_cofdm_map1, ce, m_pd);

itpp_sci_assert((abs((m_map(2,:)).' - y_map) < epsilon) == to_bvec(ones(NFFT,1)), "my_map(2) != y_map");

m_mod = SCI_PROC(p_cofdm_mod1, ce, m_map);
m_dem = SCI_PROC(p_cofdm_dem1, ce, m_mod);
m_pd_dem = SCI_PROC(p_cofdm_demap1, ce, m_dem);

itpp_sci_assert(m_pd_dem == m_pd, "m_pd_dem != m_pd");


SCI_DESTROY(p_cofdm_mod1);
SCI_DESTROY(p_cofdm_dem1);
SCI_DESTROY(p_cofdm_map1);
SCI_DESTROY(p_cofdm_demap1);
SCI_DESTROY(p_cofdm_sel1);

format('v',10);

//---------------------------
if (~ exists('ITPP_SCI_LIB'))
    ulink(id);
    printf('So, this is it \n');
end
//---------------------------

