//! test itpp_sci interface
//---------------------------

path=get_absolute_file_path("sci_pam1.sce");
chdir(path);
pwd;

//---------------------------
if (~ exists('ITPP_SCI_LIB'))
  clear;
  clc;
  lines(0);
  dbg=0;
  exec("..\..\lib\sci_api1.sci");
  exec("..\..\lib\sci_func1.sci");  
end
//---------------------------

epsilon = 1.0E-6;
M = 8;

ivx = (linspace(0, M-1, M)).'; // column vectors are returned by itpp_sci
v_ref = [-0.8750000; -0.6250000; -0.3750000; -0.1250000; 0.1250000; 0.3750000; 0.6250000; 0.8750000];

ce(1:M,1) = %T;
true_vec(1:M,1) = %T;

p_mod1 = SCI_CREATE(SCI_PAM_MOD);
sci_type = SCI_GET(p_mod1, SCI_TYPE);
itpp_sci_assert(sci_type == SCI_PAM_MOD, "sci_type != SCI_PAM_MOD");

p_dem1 = SCI_CREATE(SCI_PAM_DEM);
sci_type = SCI_GET(p_dem1, SCI_TYPE);
itpp_sci_assert(sci_type == SCI_PAM_DEM, "sci_type != SCI_PAM_DEM");

SCI_SET(p_mod1, SCI_SIZE, M);
itpp_sci_assert(SCI_GET(p_mod1, SCI_SIZE) == M, "pam_mod1.get_size() != M");

SCI_SET(p_dem1, SCI_SIZE, M);
itpp_sci_assert(SCI_GET(p_dem1, SCI_SIZE) == M, "pam_dem1.get_size() != M");

v =  SCI_PROC(p_mod1, ce, ivx);
ivy = SCI_PROC(p_dem1, ce, v);  

itpp_sci_assert(ivy == ivx, "ivy ! =ivx");
itpp_sci_assert((abs(v - v_ref) < epsilon) == true_vec, "v ! =v_ref");

SCI_DESTROY(p_mod1);
SCI_DESTROY(p_dem1);

//---------------------------
if (~ exists('ITPP_SCI_LIB'))
    ulink(id);
    printf('So, this is it \n');
end
//---------------------------

