//!  SCI_TEDG_X test
//---------------------------

path=get_absolute_file_path("sci_tedg_x1.sce");
chdir(path);
pwd
//---------------------------
if (~ exists('ITPP_SCI_LIB'))
  clear;
  clc;
  lines(0);
  dbg=0;
  exec("..\..\lib\sci_api1.sci");
  exec("..\..\lib\sci_func1.sci");  
end
//---------------------------


epsilon = 1.0E-6;
true_vec(1:3,1)=%T;

p_tedg_x1 = SCI_CREATE(SCI_TEDG_X);
sci_type = SCI_GET(p_tedg_x1, SCI_TYPE);
itpp_sci_assert(sci_type == SCI_TEDG_X, "sci_type != SCI_TEDG_X");

SCI_SET(p_tedg_x1, SCI_MODE, TEDG_MODE_STD);
itpp_sci_assert(SCI_GET(p_tedg_x1, SCI_MODE) == TEDG_MODE_STD, "mode != TEDG_MODE_STD");

// ceio[cei|ceo]
ceio = to_bmat([1 1; 1 0; 1 1]);
// perfect timing for triangle waveform
x = [1.0 0.0 -1.0];
x_x = x +%i*x;
y_x_ref = ([0.000+%i*0.000, 0.000+%i*0.000, 0.000+%i*0.000]).';
y_x = SCI_PROC(p_tedg_x1, ceio, x_x);
itpp_sci_assert((abs(y_x - y_x_ref) < epsilon) == true_vec, "y_x != y_x_ref");

// late timing for triangle waveform
x = [0.5 -0.5 -0.5];
x_x = x +%i*x;
y_x_ref = ([-0.500-%i*0.500, -0.500-%i*0.500, 0.500+%i*0.500]).';
y_x = SCI_PROC(p_tedg_x1, ceio, x_x);
itpp_sci_assert((abs(y_x - y_x_ref) < epsilon) == true_vec, "y_x != y_x_ref");


// early timing for triangle waveform
x = [0.5 0.5 -0.5];
x_x = x+ %i*x;
y_x_ref = ([-0.500-%i*0.500, -0.500-%i*0.500, -0.500-%i*0.500]).';
y_x = SCI_PROC(p_tedg_x1, ceio, x_x);
itpp_sci_assert((abs(y_x - y_x_ref) < epsilon) == true_vec, "y_x != y_x_ref");

SCI_DESTROY(p_tedg_x1);

//---------------------------
if (~ exists('ITPP_SCI_LIB'))
    ulink(id);
    printf('So, this is it \n');
end
//---------------------------

