'''
Created on Jun 21, 2015

@author: mk
'''
import numpy    as np
import ctypes   as ct
import copy     as copy
import os, sys

lib_path = os.path.abspath(os.path.join('..', '..', 'lib'))
# scipy_itpp is in lib_path = ..\..\lib
if not(lib_path in sys.path):
    sys.path.append(lib_path)

from scipy_itpp  import *
from scipy_assert  import *

N = 10
TAPS = 5

c0 = np.ones(shape=(TAPS))*0.1
ce = np.ndarray(shape=(N), dtype=bool)
x = np.zeros(shape=(N))
x[0] = 1.0
ce[0:N] = True

p_fir1 = SCI_CREATE(SCI_FIR)
sci_type = SCI_GET(p_fir1, SCI_TYPE)
itpp_sci_assert(sci_type == SCI_FIR, "type != SCI_FIR")
    
SCI_SET(p_fir1, SCI_TAPS, c0)
SCI_EXEC(p_fir1, SCI_RESET)
c1 = SCI_GET(p_fir1, SCI_TAPS)
z1 = SCI_GET(p_fir1, SCI_STATE)
itpp_sci_assert(c1 == c0, "c1 != c0");
itpp_sci_assert(z1 == np.zeros(shape=(TAPS)), "z1 != zeros(TAPS)");

y = SCI_PROC(p_fir1, ce, x)
yref = np.hstack((c0, np.zeros(shape=(N-TAPS))))
itpp_sci_assert(y == yref, "y != yref");

SCI_DESTROY(p_fir1)

if __name__ == '__main__':

    print "sci_fir1.py"
    print "c0=", c0
    print "ce=", ce.astype(int)
    print "x =", x
    print "y =", y
    print "------------"