'''
Created on Jun 21, 2015

@author: maki
'''
import numpy    as np
import ctypes   as ct
import copy     as copy

import os, sys
# scipy_itpp is in lib_path = ..\..\lib
lib_path = os.path.abspath(os.path.join('..', '..', 'lib'))
if not(lib_path in sys.path):
    sys.path.append(lib_path)

from scipy_itpp  import *   
from scipy_assert  import *

#----------------------------------------
# J.83B standard - PRBS randomizer
#            1+X3+X4  for PRBS 4 = 2^4-1
#          0 1 2 3 4   
# c0=bvec("1 0 0 1 1");
# N=c0.length()-1;
c0 = np.array([1, 0, 0, 1, 1], dtype = bool)
L = c0.size-1 
M = int((2**L)-1)   # prbs sequence lenght
W = M;              # symbol size == prbs sequence

p_lfsr1 = SCI_CREATE(SCI_LFSR)
sci_type = SCI_GET(p_lfsr1, SCI_TYPE)
itpp_sci_assert(sci_type == SCI_LFSR, "sci_type != SCI_LFSR")

SCI_SET(p_lfsr1, SCI_POLY, c0);
SCI_SET(p_lfsr1, SCI_SYMBOL_SIZE, W)

c1 = SCI_GET(p_lfsr1, SCI_POLY)
itpp_sci_assert(c1 == c0, "c1 != c0")
reverse_flag = SCI_GET(p_lfsr1, SCI_REVERSE_FLAG);
itpp_sci_assert(reverse_flag, "reverse_flag != True")

z0 = np.ndarray(shape=(L), dtype=bool)
z0[0:L] = False
z0[L-1] = True
z1 = SCI_GET(p_lfsr1, SCI_STATE) 
itpp_sci_assert(z1 == z0, "z1 != z0")

W1 = SCI_GET(p_lfsr1, SCI_SYMBOL_SIZE)
itpp_sci_assert(W1 == W, "W1 != W")

N = 4;
ce = np.ndarray(shape=(N), dtype=bool)        
ce[0:N] = True;
# where a[::-1]  is a reverse http://mathesaurus.sourceforge.net/matlab-numpy.html
yref1 = np.ndarray(shape=(N,W), dtype=bool) # one symbol is whole PRBS sequence, so you should get N identical symbols
for i in range(N):
    yref1[i,:] = np.array([0, 0, 1, 1, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 1], dtype = bool)[::-1] 
    
y1 = SCI_GEN(p_lfsr1, ce)
itpp_sci_assert(y1 == yref1, "y1 != yref1")

SCI_SET(p_lfsr1, SCI_REVERSE_FLAG, False)
reverse_flag = SCI_GET(p_lfsr1, SCI_REVERSE_FLAG);
itpp_sci_assert(not reverse_flag, "reverse_flag != False")
yref2 = np.ndarray(shape=(N,W), dtype=bool) # one symbol is whole PRBS sequence, so you should get N identical symbols
for i in range(N):
    yref2[i,:] = np.array([0, 0, 1, 1, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 1], dtype = bool)
y2 = SCI_GEN(p_lfsr1, ce)
itpp_sci_assert(y2 == yref2, "y2 != yref2")

SCI_DESTROY(p_lfsr1)

if __name__ == '__main__':
    
    print "sci_lfsr1.py"
    print "c0=\n", c0.astype(int)
    print "ce=\n", ce.astype(int)
    print "z1=\n", z1.astype(int)
    print "y1=\n", y1.astype(int)
    print "y2=\n", y2.astype(int)
    print "------------"