'''
Created on Jun 21, 2015

@author: mk
'''
import numpy    as np
import ctypes   as ct
import copy     as copy

import os, sys
# scipy_itpp is in lib_path = ..\..\lib
lib_path = os.path.abspath(os.path.join('..', '..', 'lib'))
if not(lib_path in sys.path):
    sys.path.append(lib_path)

from scipy_itpp  import *   
from scipy_assert  import *

N = 4
M = N*4
p_cnt1 = SCI_CREATE(SCI_COUNTER)
sci_type = SCI_GET(p_cnt1, SCI_TYPE)
itpp_sci_assert(sci_type == SCI_COUNTER, "sci_type != SCI_COUNTER")

SCI_SET(p_cnt1, SCI_PARAM_N, N)
itpp_sci_assert(N ==  SCI_GET(p_cnt1, SCI_PARAM_N) , "N != get_N()")

ce = np.ndarray(shape=(M), dtype=bool)
ce[0:M] = True
yref = np.ndarray(shape=(M), dtype=bool)
yref[0:M] = False
c0 = 0
for i in range(M):
    c0 = c0 + 1
    if (c0 == N):
        c0 = 0
        yref[i] = True;

y = SCI_GEN(p_cnt1, ce);
itpp_sci_assert(y == yref, "y != yref");

c0 = SCI_GET(p_cnt1, SCI_STATE);
itpp_sci_assert(c0 == 0, "c0 != 0");

SCI_SET(p_cnt1, SCI_STATE, N - 1); 
c0 = SCI_GET(p_cnt1, SCI_STATE);
itpp_sci_assert(c0 == N - 1, "c0 != N-1");

SCI_EXEC(p_cnt1, SCI_RESET);
c0 = SCI_GET(p_cnt1, SCI_STATE);
itpp_sci_assert(c0 == 0, "c0 != 0");

SCI_DESTROY(p_cnt1);

if __name__ == '__main__':
    
    print "sci_counter1.py"
    print "ce=\n", ce.astype(int)
    print "y=\n", y.astype(int)
    print "------------"