'''
Created on Jun 21, 2015

@author: mk
'''
import numpy    as np
import ctypes   as ct
import copy     as copy

import os, sys
# scipy_itpp is in lib_path = ..\..\lib
lib_path = os.path.abspath(os.path.join('..', '..', 'lib'))
if not(lib_path in sys.path):
    sys.path.append(lib_path)

from scipy_itpp  import *   
from scipy_assert  import *

# Symbol size
W = 4
# LSR FIFO length in symbols  
D = 3
# ----------------------------------
# set LSR memory length 
L = D*W
# clock ticks  
N = 2*D
# test patterns by prbs generator 2^4-1    
PRBS = 4

p_lfsr1 = SCI_CREATE(SCI_LFSR)
sci_type = SCI_GET(p_lfsr1, SCI_TYPE)
itpp_sci_assert(sci_type == SCI_LFSR, "sci_type != SCI_LFSR")

p_lsr1 = SCI_CREATE(SCI_LSR)
sci_type = SCI_GET(p_lsr1, SCI_TYPE)
itpp_sci_assert(sci_type == SCI_LSR, "sci_type != SCI_LSR")

# set length and symbol_size as minimal setup
SCI_SET(p_lsr1, SCI_LENGTH, L)
SCI_SET(p_lsr1, SCI_SYMBOL_SIZE, W)
T = SCI_GET(p_lsr1, SCI_LENGTH)
itpp_sci_assert(T == L, "T != L")
T = SCI_GET(p_lsr1, SCI_SYMBOL_SIZE)
itpp_sci_assert(T == W, "T != W")

# set LFSR as prbs generator
SCI_SET(p_lfsr1, SCI_PRBS, PRBS)
SCI_SET(p_lfsr1, SCI_SYMBOL_SIZE, W)

# generate ce
ce = np.ndarray(shape=(N), dtype=bool)        
ce[0:N] = True
 
# generate symbols
x = SCI_GEN(p_lfsr1, ce)
x_ref = np.array([[1, 1, 0, 0], [ 1, 0, 1, 0], [0, 1, 1, 1], [ 0, 1, 0, 0], [0, 1, 1, 0], [1, 1, 0, 1]], dtype = bool)
ce_ref = np.array([1, 1, 1, 1, 1, 1] , dtype = bool)
y_ref = np.array([[0, 0, 0, 0], [0, 0, 0, 0], [0, 0, 0, 0], [1, 1, 0, 0], [1, 0, 1, 0], [0, 1, 1, 1]], dtype = bool)
itpp_sci_assert(x == x_ref, "x != x_ref")
itpp_sci_assert(ce == ce_ref, "ce != ce_ref")
y = SCI_PROC(p_lsr1, ce, x)
itpp_sci_assert(y == y_ref, "y != y_ref")

SCI_DESTROY(p_lfsr1)
SCI_DESTROY(p_lsr1)

if __name__ == '__main__':
    
    print "sci_lsr1.py"
    print "x= \n", x.astype(int)
    print "ce= \n", ce.astype(int)
    print "y= \n", y.astype(int)
    print "------------"