'''
Created on Jun 21, 2015

@author: maki
'''
import numpy    as np
import ctypes   as ct
import copy     as copy
import os, sys

lib_path = os.path.abspath(os.path.join('..', '..', 'lib'))
# scipy_itpp is in lib_path = ..\..\lib
if not(lib_path in sys.path):
    sys.path.append(lib_path)

from scipy_itpp  import *
from scipy_assert  import *

M = 4
p_qmod1 = SCI_CREATE(SCI_QAM_MOD)
sci_type = SCI_GET(p_qmod1, SCI_TYPE)
itpp_sci_assert(sci_type == SCI_QAM_MOD, "sci_type != SCI_QAM_MOD")

p_qdem1 = SCI_CREATE(SCI_QAM_DEM)
sci_type = SCI_GET(p_qdem1, SCI_TYPE)
itpp_sci_assert(sci_type == SCI_QAM_DEM, "sci_type != SCI_QAM_DEM")

SCI_SET(p_qmod1, SCI_SIZE, M)
m = SCI_GET(p_qmod1, SCI_SIZE)
itpp_sci_assert(m == M, "m != M")

SCI_SET(p_qdem1, SCI_SIZE, M);
m = SCI_GET(p_qdem1, SCI_SIZE);
itpp_sci_assert(m == M, "m != M")

ivx = np.array([0, 1, 2, 3], dtype=int)
cv_ref = np.array([0.50000+0.50000*1j, -0.50000+0.50000*1j, 0.50000-0.50000*1j, -0.50000-0.50000*1j], dtype=complex)
ivy_ref = ivx;
ce = np.ndarray(shape=(M), dtype=bool)
ce[0:M]=True;

cv =  SCI_PROC(p_qmod1, ce, ivx);
ivy = SCI_PROC(p_qdem1, ce, cv); 

itpp_sci_assert(cv == cv_ref, "cv!=cv_ref");
itpp_sci_assert(ivy == ivy_ref, "ivy!=ivy_ref");

SCI_DESTROY(p_qmod1);
SCI_DESTROY(p_qdem1);

if __name__ == '__main__':

    print "sci_qam1.py"
    print "ce=", ce.astype(int)
    print "ivx=", ivx
    print "cv=", cv
    print "------------"

