'''
Created on Jun 21, 2015

@author: mk
'''
import numpy    as np
import ctypes   as ct
import copy     as copy

import os, sys
# scipy_itpp is in lib_path = ..\..\lib
lib_path = os.path.abspath(os.path.join('..', '..', 'lib'))
if not(lib_path in sys.path):
    sys.path.append(lib_path)

from scipy_itpp  import *   
from scipy_assert  import *

# number of symbols
N = 16;    
# Symbol size
W = 4;
ce = np.ndarray(shape=(N), dtype=bool)
ce[0:N] = True
# [0:N-1]
x1 = np.ndarray(shape=(N), dtype=int)
x1 = np.arange(N)

p_i2b1 = SCI_CREATE(SCI_INT2BIN)
sci_type = SCI_GET(p_i2b1, SCI_TYPE)
itpp_sci_assert(sci_type == SCI_INT2BIN, "sci_type != SCI_INT2BIN")

p_b2i1 = SCI_CREATE(SCI_BIN2INT)
sci_type = SCI_GET(p_b2i1, SCI_TYPE)
itpp_sci_assert(sci_type == SCI_BIN2INT, "sci_type != SCI_BIN2INT")

SCI_SET(p_i2b1, SCI_SYMBOL_SIZE, W)
SCI_SET(p_b2i1, SCI_SYMBOL_SIZE, W)

itpp_sci_assert(W == SCI_GET(p_i2b1, SCI_SYMBOL_SIZE), "W != SCI_GET(p_i2b1, SCI_SYMBOL_SIZE)")
itpp_sci_assert(W == SCI_GET(p_b2i1, SCI_SYMBOL_SIZE), "W != SCI_GET(p_b2i1, SCI_SYMBOL_SIZE)")
itpp_sci_assert(SCI_GET(p_i2b1, SCI_MSB_FLAG), "true != SCI_GET(p_i2b1, SCI_MSB_FLAG)")
itpp_sci_assert(SCI_GET(p_b2i1, SCI_MSB_FLAG), "true != SCI_GET(p_b2i1, SCI_MSB_FLAG)")

y1_ref = np.array([[0, 0, 0, 0], [0, 0, 0, 1], [0, 0, 1, 0], [0, 0, 1, 1], [0, 1, 0, 0], [0, 1, 0, 1], [0, 1, 1, 0], [0, 1, 1, 1],\
                   [1, 0, 0, 0], [1, 0, 0, 1], [1, 0, 1, 0], [1, 0, 1, 1], [1, 1, 0, 0], [1, 1, 0, 1], [1, 1, 1, 0], [1, 1, 1, 1]], dtype = bool )

y1 = SCI_PROC(p_i2b1, ce, x1)
itpp_sci_assert(y1 == y1_ref, "y1 != y1_ref")

y2 = SCI_PROC(p_b2i1, ce, y1)
itpp_sci_assert(y2 == x1, "y2 != x1")

# make a copy of normally generated symbols with MSB = y[0]
y1n = y1.copy()

SCI_SET(p_i2b1, SCI_MSB_FLAG, False)
SCI_SET(p_b2i1, SCI_MSB_FLAG, False)
itpp_sci_assert(~SCI_GET(p_i2b1, SCI_MSB_FLAG), "true = SCI_GET(p_i2b1, SCI_MSB_FLAG)")
itpp_sci_assert(~SCI_GET(p_b2i1, SCI_MSB_FLAG), "true = SCI_GET(p_b2i1, SCI_MSB_FLAG)")
itpp_sci_assert(W == SCI_GET(p_i2b1, SCI_SYMBOL_SIZE), "W != SCI_GET(p_i2b1, SCI_SYMBOL_SIZE)")
itpp_sci_assert(W == SCI_GET(p_b2i1, SCI_SYMBOL_SIZE), "W != SCI_GET(p_b2i1, SCI_SYMBOL_SIZE)")

for i in range(N):
    y1_ref[i,:] = y1_ref[i,:][::-1];

y1 = SCI_PROC(p_i2b1, ce, x1);
itpp_sci_assert(y1 == y1_ref, "y1 != y1_ref");

y2 = SCI_PROC(p_b2i1, ce, y1);
itpp_sci_assert(y2 == x1, "y2 != x1");
       
SCI_DESTROY(p_i2b1);
SCI_DESTROY(p_b2i1);

if __name__ == '__main__':
    
    print "sci_bin2int.py"
    print "ce= \n", ce.astype(int)
    print "x1= \n", x1.astype(int)
    print "y1n= \n", y1n.astype(int)
    print "y1= \n", y1.astype(int)
    print "y2= \n", y2.astype(int)
    print "------------"