'''
Created on Jun 21, 2015

@author: mk
'''
import numpy    as np
import ctypes   as ct
import copy     as copy

import os, sys
# scipy_itpp is in lib_path = ..\..\lib
lib_path = os.path.abspath(os.path.join('..', '..', 'lib'))
if not(lib_path in sys.path):
    sys.path.append(lib_path)

from scipy_itpp  import *   
from scipy_assert  import *

MAV = 10                # mav lenght	
N = 20                  # sequence length
epsilon = 1.0E-5

p_rms1 = SCI_CREATE(SCI_RMS)
sci_type = SCI_GET(p_rms1, SCI_TYPE)
itpp_sci_assert(sci_type == SCI_RMS, "sci_type != SCI_RMS")

p_rms_x1 = SCI_CREATE(SCI_RMS_X)
sci_type = SCI_GET(p_rms_x1, SCI_TYPE)
itpp_sci_assert(sci_type == SCI_RMS_X, "sci_type != SCI_RMS_X")

ce = np.ndarray(shape=(N), dtype=bool)
true_vec = np.ndarray(shape=(N), dtype=bool)
x1 = np.ndarray(shape=(N), dtype=float)
x_x1 = np.ndarray(shape=(N), dtype=complex)


ce[0:N] = True
true_vec[0:N] = True
x1[0:N] = 1
x_x1[0:N] = x1 +1j*x1

SCI_SET(p_rms1,SCI_SIZE,MAV);	
itpp_sci_assert(SCI_GET(p_rms1, SCI_SIZE) == MAV, "rms1.size !=MAV");
SCI_SET(p_rms_x1, SCI_SIZE, MAV);
itpp_sci_assert(SCI_GET(p_rms_x1, SCI_SIZE) == MAV, "rms_x1.size !=MAV");

#       sqrt(MAV 1.0 step response)
#       sqrt(0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.0 1.0......)
y1_ref = np.array([0.31623, 0.44721, 0.54772, 0.63246, 0.70711, 0.77460, 0.83666, 0.89443, 0.94868,
                   1.00000, 1.00000, 1.00000, 1.00000, 1.00000, 1.00000, 1.00000, 1.00000, 1.00000, 1.00000, 1.00000], dtype = float )
y1 = SCI_PROC(p_rms1, ce, x1);
itpp_sci_assert((abs(y1 - y1_ref) < epsilon) == true_vec, "abs(y1 - y1_ref) > epsilon ");

#   sqrt(MAV sqrt(2) step response)
#   sqrt(2)*sqrt(0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.0 1.0......)
y_x1_ref = np.array([0.44721, 0.63246, 0.77460, 0.89443, 1.00000, 1.09545, 1.18322, 1.26491, 1.34164,
                     1.41421, 1.41421, 1.41421, 1.41421, 1.41421, 1.41421, 1.41421, 1.41421, 1.41421, 1.41421, 1.41421], dtype = float );
y_x1 = SCI_PROC(p_rms_x1, ce, x_x1);
itpp_sci_assert((abs(y_x1 - y_x1_ref) < epsilon) == true_vec, "abs(y_x1 - y_x1_ref) > epsilon ");

SCI_DESTROY(p_rms1);
SCI_DESTROY(p_rms_x1);

if __name__ == '__main__':

    print "sci_rms1.py"
    print "epsilon = ", epsilon
    print "ce =", ce.astype(int)
    print "x1 =", x1
    print "y1 =", y1
    print "abs(y1 - y1_ref) < epsilon = ", (abs(y1 - y1_ref) < epsilon).astype(int)
    print "x_x1 =", x_x1
    print "y_x1 =", y_x1
    print "abs(y_x1 - y_x1_ref) < epsilon = ", (abs(y_x1 - y_x1_ref) < epsilon).astype(int)
    print "------------"