'''
Created on Nov 07, 2015

@author: maki
'''
import numpy    as np
import ctypes   as ct
import copy     as copy

import os, sys
# scipy_itpp is in lib_path = ..\..\lib
lib_path = os.path.abspath(os.path.join('..', '..', 'lib'))
if not(lib_path in sys.path):
    sys.path.append(lib_path)

from scipy_itpp  import *   
from scipy_assert  import *

N = 1000      # sequence length

sigma_x1_ref = 0.1
mean_x1_ref = 0.2
sigma_x_x1_ref = 0.15
mean_x_x1_ref = 0.25 - 1j*0.25
epsilon = 3.0E-1 # 30 %

ce = np.ndarray(shape=(N), dtype=bool)
ce[0:N] = True

p_wgn1 = SCI_CREATE(SCI_WGN)
sci_type = SCI_GET(p_wgn1, SCI_TYPE)
itpp_sci_assert(sci_type == SCI_WGN, "sci_type != SCI_WGN")
SCI_SET(p_wgn1, SCI_SIGMA, sigma_x1_ref)
itpp_sci_assert(SCI_GET(p_wgn1, SCI_SIGMA) == sigma_x1_ref, "wgn1.get_sigma() != sigma_x1_ref")
SCI_SET(p_wgn1, SCI_MEAN, mean_x1_ref)
itpp_sci_assert(SCI_GET(p_wgn1, SCI_MEAN) == mean_x1_ref, "wgn1.get_mean() != mean_x1_ref")

p_wgn_x1 = SCI_CREATE(SCI_WGN_X)
sci_type = SCI_GET(p_wgn_x1, SCI_TYPE)
itpp_sci_assert(sci_type == SCI_WGN_X, "sci_type != SCI_WGN_X")
SCI_SET(p_wgn_x1, SCI_SIGMA, sigma_x_x1_ref)
itpp_sci_assert(SCI_GET(p_wgn_x1, SCI_SIGMA) == sigma_x_x1_ref, "wgn_x1.get_sigma() != sigma_x_x1_ref")
SCI_SET(p_wgn_x1, SCI_MEAN, mean_x_x1_ref)
itpp_sci_assert(SCI_GET(p_wgn_x1, SCI_MEAN) == mean_x_x1_ref, "wgn_x1.get_mean() != mean_x_x1_ref")

x1 = SCI_GEN(p_wgn1,ce)
mean_x1 = np.mean(x1)
if mean_x1_ref != 0.0:
    itpp_sci_assert(abs((mean_x1 - mean_x1_ref) / mean_x1_ref) < epsilon, "abs((mean_x1 - mean_x1_ref) / mean_x1_ref) > epsilon")

# variance = E[(X-m)^2] = E[x^2] | X=x+m
sigma_x1 = np.sqrt(np.var(x1));
itpp_sci_assert((sigma_x1 - sigma_x1_ref) < epsilon*sigma_x1_ref, "(sigma_x1 - sigma_x1_ref)/sigma_x1_ref > epsilon*sigma_x1_ref");

x_x1 = SCI_GEN(p_wgn_x1, ce)
mean_x_x1 = np.mean(x_x1)
if abs(mean_x_x1_ref) != 0.0:
    itpp_sci_assert((abs(mean_x1) - abs(mean_x1_ref)) / abs(mean_x1_ref) < epsilon, "abs((abs(mean_x1) - abs(mean_x1_ref)) / abs(mean_x1_ref) > epsilon");

# variance = E[(X-m)*(conj(X)-conj(m))] = E[x*conj(x)] | X=x+m
sigma_x_x1 = np.sqrt(np.var(x_x1));
itpp_sci_assert((sigma_x_x1 - sigma_x_x1_ref) < epsilon*sigma_x_x1_ref, "(sigma_x_x1 - sigma_x_x1_ref)/sigma_x_x1_ref > epsilon*sigma_x1_ref");

SCI_DESTROY(p_wgn1);
SCI_DESTROY(p_wgn_x1);


if __name__ == '__main__':

    print "sci_wgn1.py"
    print "N = ", epsilon
    print "epsilon = ", epsilon
    print "mean_x1 = ", mean_x1
    print "mean_x1_ref = ", mean_x1_ref
    print "sigma_x1 = ", sigma_x1
    print "sigma_x1_ref = ", sigma_x1_ref
    print "mean_x_x1 = ", mean_x_x1
    print "mean_x_x1_ref = ", mean_x_x1_ref
    print "sigma_x_x1 = ", sigma_x_x1
    print "sigma_x_x1_ref = ", sigma_x_x1_ref

    print "------------"