'''
Created on Jun 21, 2015

@author: mk
'''
import numpy    as np
import ctypes   as ct
import copy     as copy

import os, sys
# scipy_itpp is in lib_path = ..\..\lib
lib_path = os.path.abspath(os.path.join('..', '..', 'lib'))
if not(lib_path in sys.path):
    sys.path.append(lib_path)

from scipy_itpp  import *
from scipy_assert  import *

TAPS = 8
N = 2 * TAPS

# counter generates cei|ceo
cei = np.ndarray(shape=(N), dtype=bool)
ceo = np.ndarray(shape=(N), dtype=bool)
ce = np.ndarray(shape=(N,2), dtype=bool)
p_cnt1 = SCI_CREATE(SCI_COUNTER)		
SCI_SET(p_cnt1, SCI_PARAM_N, TAPS)
SCI_SET(p_cnt1, SCI_STATE, TAPS - 1)
ceo[0:N] = True
cei = SCI_GEN(p_cnt1, ceo) 
ce[:,0] = cei
ce[:,1] = ceo

# fir_up filter is MAV	 
c0 = np.ones(shape=(TAPS))*(1.0 / TAPS)
p_fir_up1 = SCI_CREATE(SCI_FIR_UP)
sci_type = SCI_GET(p_fir_up1, SCI_TYPE)
itpp_sci_assert(sci_type == SCI_FIR_UP, "sci_type != SCI_FIR_UP")
SCI_SET(p_fir_up1, SCI_TAPS, c0)
SCI_EXEC(p_fir_up1, SCI_RESET)
c1 = SCI_GET(p_fir_up1, SCI_TAPS)
z1 = SCI_GET(p_fir_up1, SCI_STATE)
itpp_sci_assert(c1 == c0, "c1 != c0")
itpp_sci_assert(z1 == np.zeros(shape=(TAPS)), "z1 != zeros(TAPS)")

# set up input signal
x = np.zeros(shape=(N))
x[0:N]=1.0
# process
y = SCI_PROC(p_fir_up1, ce, x)
#  y should be constant signal 
y_ref = np.ones(shape=(N))*(1.0 / TAPS)
itpp_sci_assert(y == y_ref, "y != y_ref")


# fir_up_x filter is complex MAV 
c_x0 = c0 + 1j*c0
p_fir_up_x1 = SCI_CREATE(SCI_FIR_UP_X)
sci_type = SCI_GET(p_fir_up_x1, SCI_TYPE)
itpp_sci_assert(sci_type == SCI_FIR_UP_X, "sci_type != SCI_FIR_UP_X")

SCI_SET(p_fir_up_x1, SCI_TAPS, c_x0)
SCI_EXEC(p_fir_up_x1, SCI_RESET)
c_x1 = SCI_GET(p_fir_up_x1, SCI_TAPS)
z_x = SCI_GET(p_fir_up_x1, SCI_STATE)

itpp_sci_assert(c_x1 == c_x0, "c_x1 != c_x0")
itpp_sci_assert(z_x == np.zeros(shape=(TAPS))+1j*np.zeros(shape=(TAPS)), "z_x != zeros(TAPS)")

# set up input signal
x_x=np.ones(shape=(N)) + 1j*np.zeros(shape=(N))
# process
y_x = SCI_PROC(p_fir_up_x1, ce, x_x)
#  y should be constant complex signal 
y_x_ref = (np.ones(shape=(N))+1j*np.ones(shape=(N)))*(1.0 / TAPS)
itpp_sci_assert(y_x == y_x_ref, "y_x != y_x_ref")

SCI_DESTROY(p_cnt1)
SCI_DESTROY(p_fir_up1)
SCI_DESTROY(p_fir_up_x1)

if __name__ == '__main__':

    print "sci_fir_up1.py"
    print "y=", y
    print "y_x=", y_x
    print "------------"
