'''
Created on Jun 21, 2015

@author: mk
'''
import numpy    as np
import ctypes   as ct
import copy     as copy

import os, sys
# scipy_itpp is in lib_path = ..\..\lib
lib_path = os.path.abspath(os.path.join('..', '..', 'lib'))
if not(lib_path in sys.path):
    sys.path.append(lib_path)

from scipy_itpp  import *
from scipy_assert  import *

# input is L/M  checked for cases 1/8; 2/9; -1/8; -2/9;
# 1/8 is an easy test; 
# 2/9 more complicated case - nco fails for L/M exactly 2/9  
# the ideal sequence looks like this below - vco produces a sequence with cy jitter 
#  [0][-2 / 9], [0][-4 / 9], [0][-6 / 9], [0][-8 / 9], [-1][-1 / 9],
#  [0][-3 / 9], [0][-5 / 9], [0][-7 / 9], [-1][0 / 9],
#  [0][-2 / 9], [0][-4 / 9], [0][-6 / 9], [0][-8 / 9], [-1][-1 / 9],
#  [0][-3 / 9], [0][-5 / 9], [0][-7 / 9], [-1][0 / 9],
# in nco - double fractional input x[i] is rounded during conversion to fixed point Q1.N and this might be a reason (or not?)...

L = -2.000001
M = 9.0
N = 3 * M
Nq_bits = 60 # NCO phase accumulator format is Q1.Nq_bits
epsilon = 1.0E-6

ce = np.ndarray(shape=(N), dtype=bool)
ce[0:N]=True
true_vec = np.ndarray(shape=(N), dtype=bool)
true_vec[0:N]=True
x = np.ndarray(shape=(N), dtype=float)
x[0:N]=(L/M)

p_nco1 = SCI_CREATE(SCI_NCO)
sci_type = SCI_GET(p_nco1, SCI_TYPE)
itpp_sci_assert(sci_type == SCI_NCO, "sci_type != SCI_NCO")
SCI_SET(p_nco1, SCI_PARAM_N, Nq_bits)
itpp_sci_assert(SCI_GET(p_nco1, SCI_PARAM_N) == Nq_bits, "nco1.get_N() != Nq_bits")

p_vco1 = SCI_CREATE(SCI_VCO)
sci_type = SCI_GET(p_vco1, SCI_TYPE)
itpp_sci_assert(sci_type == SCI_VCO, "sci_type != SCI_VCO")

nco_y = SCI_PROC(p_nco1, ce, x)
vco_y = SCI_PROC(p_vco1, ce, x)
#  cy - carry
cy_nco = (nco_y[:,0] != np.zeros(N))
cy_vco = (vco_y[:,0] != np.zeros(N))
itpp_sci_assert(cy_nco == cy_vco, "cy_nco != cy_vco")
# ph - phase
ph_nco = nco_y[:,1]
ph_vco = nco_y[:,1]
itpp_sci_assert((abs(ph_nco - ph_vco) < epsilon) == true_vec, "abs(nco_ph - vco_ph) > epsilon ");

SCI_DESTROY(p_nco1)
SCI_DESTROY(p_vco1)


if __name__ == '__main__':

    print "sci_nco1.py"
    print "[nco_y|vco_y]= \n", np.concatenate((nco_y,vco_y), axis=1)
    print "------------"
