'''
Created on Nov 26, 2015

@author: maki
'''
import numpy    as np
import ctypes   as ct
import copy     as copy

import os, sys
# scipy_itpp is in lib_path = ..\..\lib
lib_path = os.path.abspath(os.path.join('..', '..', 'lib'))
if not(lib_path in sys.path):
    sys.path.append(lib_path)

from scipy_itpp  import *
from scipy_assert  import *

L = 1.000;
M = 4.0;
N = 2 * M;
Nq_bits = 60;  # NCO phase accumulator format is Q1.Nq_bits
epsilon = 1.0E-6;

ce = np.ndarray(shape=(N), dtype=bool)
ce[0:N]=True
true_vec = np.ndarray(shape=(N), dtype=bool)
true_vec[0:N]=True
x = np.ndarray(shape=(N), dtype=float)
x[0:N]=(L/M)

p_nco1 = SCI_CREATE(SCI_NCO)

p_ejp1 = SCI_CREATE(SCI_EJP)
sci_type = SCI_GET(p_ejp1, SCI_TYPE)
itpp_sci_assert(sci_type == SCI_EJP, "ejp1.sci_type != SCI_EJP")

nco_y=SCI_PROC(p_nco1, ce, x)
print "nco_y = \n", nco_y

nco_ph = nco_y[:,1]
print "nco_ph = \n", nco_ph
print "nco_ph.flags['C_CONTIGUOUS'] = ", nco_ph.flags['C_CONTIGUOUS']

nco_ph = np.ascontiguousarray(nco_y[:,1],dtype=float) 
print "nco_ph = \n", nco_ph
print "nco_ph.flags['C_CONTIGUOUS'] = ", nco_ph.flags['C_CONTIGUOUS']
print "nco_ph.ndim = ", nco_ph.ndim

ejp_y = SCI_PROC(p_ejp1, ce, nco_ph)
ejp_ref = np.cos(2 * np.pi * nco_ph)+1j*np.sin(2 * np.pi * nco_ph)

itpp_sci_assert((np.abs(np.real(ejp_y) - np.real(ejp_ref)) < epsilon) == true_vec, "abs(real(ejp_y) - real(ejp_ref)) > epsilon ");
itpp_sci_assert((np.abs(np.imag(ejp_y) - np.imag(ejp_ref)) < epsilon) == true_vec, "abs(imag(ejp_y) - imag(ejp_ref)) > epsilon ");

SCI_DESTROY(p_nco1);
SCI_DESTROY(p_ejp1);

if __name__ == '__main__':

    print "sci_ejp1.py"
    print "ejp_y.ndim = ", ejp_y.ndim
    print "ejp_y.shape = ", ejp_y.shape
    print "ejp_y = \n", ejp_y
    print "ejp_ref.ndim = ", ejp_ref.ndim
    print "ejp_ref.shape = ", ejp_ref.shape
    print "ejp_ref = \n", ejp_ref
    a = np.ndarray(shape=(N,2), dtype=complex)
    a[:,0] = ejp_y
    a[:,1] = ejp_ref
    print "[ejp_y|ejp_ref]= \n", a
    print "------------"
