'''
Created on Nov 26, 2015

@author: maki
'''
import numpy    as np
import ctypes   as ct
import copy     as copy

import os, sys
# scipy_itpp is in lib_path = ..\..\lib
lib_path = os.path.abspath(os.path.join('..', '..', 'lib'))
if not(lib_path in sys.path):
    sys.path.append(lib_path)

from scipy_itpp  import *
from scipy_assert  import *

N = 10      # sequence length
g1_gain = 1.1
g1_offset = 0.1
g_x1_gain = 1.15 +1j*1.25
g_x1_offset = 0.15+1j*0.25

ce = np.ndarray(shape=(N), dtype=bool)
ce[0:N]=True
true_vec = np.ndarray(shape=(N), dtype=bool)
true_vec[0:N]=True

p_wgn1 = SCI_CREATE(SCI_WGN) 
p_wgn_x1 = SCI_CREATE(SCI_WGN_X)

p_g1 = SCI_CREATE(SCI_AMP)
sci_type = SCI_GET(p_g1, SCI_TYPE)
itpp_sci_assert(sci_type == SCI_AMP, "sci_type != SCI_AMP")

SCI_SET(p_g1, SCI_GAIN, g1_gain)
SCI_SET(p_g1, SCI_OFFSET, g1_offset)

itpp_sci_assert(SCI_GET(p_g1, SCI_GAIN) == g1_gain, "g1.get_gain() != g1_gain")
itpp_sci_assert(SCI_GET(p_g1, SCI_OFFSET) == g1_offset, "g1.get_offset() != g1_offset")

p_g_x1 = SCI_CREATE(SCI_AMP_X)
sci_type = SCI_GET(p_g_x1, SCI_TYPE)
itpp_sci_assert(sci_type == SCI_AMP_X, "sci_type != SCI_AMP_X")

SCI_SET(p_g_x1, SCI_GAIN, g_x1_gain)
SCI_SET(p_g_x1, SCI_OFFSET, g_x1_offset)

itpp_sci_assert(SCI_GET(p_g_x1, SCI_GAIN) == g_x1_gain, "g_x1.get_gain() != g_x1_gain")
itpp_sci_assert(SCI_GET(p_g_x1, SCI_OFFSET) == g_x1_offset, "g_x1.get_offset() != g_x1_offset")

x1 = SCI_GEN(p_wgn1, ce)
x_x1 = SCI_GEN(p_wgn_x1, ce)

y1 = SCI_PROC(p_g1, ce, x1)
y1_ref = g1_gain*x1 + g1_offset

y_x1 = SCI_PROC(p_g_x1, ce, x_x1)
y_x1_ref = g_x1_gain*x_x1 + g_x1_offset

itpp_sci_assert(y1 == y1_ref, "y1 != y1_ref")
itpp_sci_assert(y_x1 == y_x1_ref, "y_x1 != y_x1_ref")

SCI_DESTROY(p_wgn1)
SCI_DESTROY(p_wgn_x1)
SCI_DESTROY(p_g1)
SCI_DESTROY(p_g_x1)

if __name__ == '__main__':

    print "sci_amp_x1.py"
    a = np.ndarray(shape=(N,2), dtype=complex)
    a[:,0] = y_x1
    a[:,1] = y_x1_ref
    print "[y_x1|y_x1_ref]= \n", a
    print "------------"
