'''
Created on Nov 26, 2015

@author: maki
'''
import numpy    as np
import ctypes   as ct
import copy     as copy

import os, sys
# scipy_itpp is in lib_path = ..\..\lib
lib_path = os.path.abspath(os.path.join('..', '..', 'lib'))
if not(lib_path in sys.path):
    sys.path.append(lib_path)

from scipy_itpp  import *
from scipy_assert  import *

N = 10      # sequence length

ce = np.ndarray(shape=(N), dtype=bool)
ce[0:N]=True
true_vec = np.ndarray(shape=(N), dtype=bool)
true_vec[0:N]=True

p_wgn1 = SCI_CREATE(SCI_WGN) 
p_wgn_x1 = SCI_CREATE(SCI_WGN_X)

p_mix1 = SCI_CREATE(SCI_MIX);
sci_type = SCI_GET(p_mix1, SCI_TYPE);
itpp_sci_assert(sci_type == SCI_MIX, "mix1.sci_type != SCI_MIX");

p_mix_x1 = SCI_CREATE(SCI_MIX_X);
sci_type = SCI_GET(p_mix_x1, SCI_TYPE);
itpp_sci_assert(sci_type == SCI_MIX_X, "mix_x1.sci_type != SCI_MIX_X");

x1 = SCI_GEN(p_wgn1, ce);
x2 = SCI_GEN(p_wgn1, ce);
x = np.ndarray(shape=(N,2), dtype=float)
x[:,0] = x1
x[:,1] = x2
y = SCI_PROC(p_mix1, ce, x)
y_ref = x1 * x2

x_x1 = SCI_GEN(p_wgn_x1, ce);
x_x2 = SCI_GEN(p_wgn_x1, ce);
x_x = np.ndarray(shape=(N,2), dtype=complex)
x_x[:,0] = x_x1
x_x[:,1] = x_x2
y_x = SCI_PROC(p_mix_x1, ce, x_x)
y_x_ref = x_x1 * x_x2

itpp_sci_assert(y == y_ref, "y1 != y1_ref");
itpp_sci_assert(y_x == y_x_ref, "y_x1 != y_x1_ref");

SCI_DESTROY(p_wgn1)
SCI_DESTROY(p_wgn_x1)
SCI_DESTROY(p_mix1)
SCI_DESTROY(p_mix_x1)

if __name__ == '__main__':

    print "sci_amp_x1.py"
    a = np.ndarray(shape=(N,2), dtype=complex)
    a[:,0] = y_x
    a[:,1] = y_x_ref
    print "[y_x1|y_x1_ref]= \n", a
    print "------------"
