'''
Created on Nov 29, 2015

@author: maki
'''
import numpy    as np
import ctypes   as ct
import copy     as copy
import os, sys

lib_path = os.path.abspath(os.path.join('..', '..', 'lib'))
# scipy_itpp is in lib_path = ..\..\lib
if not(lib_path in sys.path):
    sys.path.append(lib_path)

from scipy_itpp  import *
from scipy_assert  import *

np.set_printoptions(precision = 4, linewidth = 250, suppress = True)

M = 16;
epsilon = 1.0E-6;

ce = np.ndarray(shape=(M), dtype=bool)
ce[0:M]=True
true_vec = np.ndarray(shape=(M), dtype=bool)
true_vec[0:M]=True

p_qmod1 = SCI_CREATE(SCI_QAM_MOD)
p_qdem1 = SCI_CREATE(SCI_QAM_DEM)
SCI_SET(p_qmod1, SCI_SIZE, M)
SCI_SET(p_qdem1, SCI_SIZE, M)


p_iq2ap1 = SCI_CREATE(SCI_IQ2AP)
sci_type = SCI_GET(p_iq2ap1, SCI_TYPE)
itpp_sci_assert(sci_type == SCI_IQ2AP, "sci_type != SCI_IQ2AP")

p_ap2iq1 = SCI_CREATE(SCI_AP2IQ)
sci_type = SCI_GET(p_ap2iq1, SCI_TYPE)
itpp_sci_assert(sci_type == SCI_AP2IQ, "sci_type != SCI_IQ2AP")

ivx = np.linspace(0,M-1,M)

cv =  SCI_PROC(p_qmod1, ce, ivx)
ap =  SCI_PROC(p_iq2ap1, ce, cv)
iq =  SCI_PROC(p_ap2iq1, ce, ap)
ivy = SCI_PROC(p_qdem1, ce, iq) 

itpp_sci_assert(ivx == ivy, "ivx!=ivy")
itpp_sci_assert((abs(cv - iq) < epsilon) == true_vec, "cv!=iq")

SCI_DESTROY(p_qmod1)
SCI_DESTROY(p_qdem1)
SCI_DESTROY(p_iq2ap1)         
SCI_DESTROY(p_ap2iq1)

y = np.ndarray(shape=(M,8), dtype=float)
y[:,0] = ivx
y[:,1] = ivy
y[:,2] = np.real(cv)
y[:,3] = np.imag(cv)
y[:,4] = np.real(iq)
y[:,5] = np.imag(iq)
y[:,6] = ap[:,0]
y[:,7] = ap[:,1]

itpp_sci_assert(ivx == ivy, "ivx!=ivy");
itpp_sci_assert((np.abs(cv - iq) < epsilon) == true_vec, "cv!=iq");

if __name__ == '__main__':

    print "sci_iq2ap.py"
#    print "ivx = \n", ivx
#    print "ivy = \n", ivy
#    print "cv = \n", cv
#    print "iq = \n", iq
#    print "ap = \n", ap
    print "y = \n", y
    print "------------"

