'''
Created on Dec 02, 2015

@author: maki
'''
import numpy    as np
import ctypes   as ct
import copy     as copy
import os, sys

lib_path = os.path.abspath(os.path.join('..', '..', 'lib'))
# scipy_itpp is in lib_path = ..\..\lib
if not(lib_path in sys.path):
    sys.path.append(lib_path)

from scipy_itpp  import *
from scipy_assert  import *

np.set_printoptions(precision = 4, linewidth = 250, suppress = True)

M = 3;
N = 10;
a = np.ndarray(shape=(M), dtype=float)
b = np.ndarray(shape=(N-M), dtype=float)

a = np.linspace(0, M-1, M)
b = np.linspace(M, N-1, N-M)
ref = np.concatenate((a, b)) 

a_x = np.ndarray(shape=(M), dtype=complex)
b_x = np.ndarray(shape=(N-M), dtype=complex)

a_x = a + 1j*np.zeros(M)
b_x = b + 1j*np.zeros(N-M)
ref_x = np.concatenate((a_x, b_x)) 

null_vec = np.ndarray(shape=(0), dtype=float)
null_cvec = np.ndarray(shape=(0), dtype=complex)


p_cb1 = SCI_CREATE(SCI_CIRCBUFF)
sci_type = SCI_GET(p_cb1, SCI_TYPE)
itpp_sci_assert(sci_type == SCI_CIRCBUFF, "sci_type != SCI_CIRCBUFF")
SCI_SET(p_cb1, SCI_SIZE, N)
itpp_sci_assert(SCI_GET(p_cb1, SCI_SIZE) == N, "cb1.get_size() != N")

p_cb_x1 = SCI_CREATE(SCI_CIRCBUFF_X)
sci_type = SCI_GET(p_cb_x1, SCI_TYPE)
itpp_sci_assert(sci_type == SCI_CIRCBUFF_X, "sci_type != SCI_CIRCBUFF_X")
SCI_SET(p_cb_x1, SCI_SIZE, N)
itpp_sci_assert(SCI_GET(p_cb_x1, SCI_SIZE) == N, "cb_x1.get_size() != N")

# put [a|b] , peek, rev_peek, get(), get(), get(), get(-1), get(-1)
SCI_SET(p_cb1, SCI_VEC, a)
SCI_SET(p_cb1, SCI_VEC, b)
out_vec = SCI_GET(p_cb1, SCI_PEEK_VEC)
itpp_sci_assert( out_vec == ref, "peek(out_vec) != ref")

out_vec = SCI_GET(p_cb1, SCI_PEEK_REV_VEC)
itpp_sci_assert( out_vec == ref[::-1], "peek_reverse(out_vec) != reverse(ref)")

v = SCI_GET(p_cb1, SCI_SINGLETON)
itpp_sci_assert(v == a[0], "v != a[0]")
v = SCI_GET(p_cb1, SCI_SINGLETON)
itpp_sci_assert(v == a[1], "v != a[1]")
v = SCI_GET(p_cb1, SCI_SINGLETON)
itpp_sci_assert(v == a[2], "v != a[2]")

out_vec = SCI_GET(p_cb1, SCI_VEC);
itpp_sci_assert( out_vec == b, "out_vec != b");

out_vec = SCI_GET(p_cb1, SCI_PEEK_VEC);
itpp_sci_assert( out_vec == null_vec, "out_vec != null_vec");

# process( M cei ticks), gen(N ticks)
cei = np.ndarray(shape=(M), dtype=bool)
ceo = np.ndarray(shape=(M), dtype=bool)
ceio = np.ndarray(shape=(M,2), dtype=bool)
cei[0:M] = True
ceo[0:M] = False
ceio[:,0] = cei
ceio[:,1] = ceo

itpp_sci_assert(SCI_GET(p_cb1, SCI_N_OF_ELEM) == 0, "cb1.nrof_elements() != 0")

y = SCI_PROC(p_cb1, ceio, a);

itpp_sci_assert(y == np.zeros(M), "y == zeros(M)");
itpp_sci_assert(SCI_GET(p_cb1, SCI_N_OF_ELEM) == M, "cb1.nrof_elements() != M");

cei = np.ndarray(shape=(N), dtype=bool)
cei[0:N] = True
y = SCI_GEN(p_cb1, cei);

ref = np.ndarray(shape=(N), dtype=float)
ref[0:M] = a
ref[M:2*M] = a
ref[2*M:3*M] = a
ref[3*M] = a[0]
itpp_sci_assert(y == ref, "y != ref");

# put [a|b] , peek, rev_peek, get(), get(), get(), get(-1), get(-1)
SCI_SET(p_cb_x1, SCI_VEC, a_x)
SCI_SET(p_cb_x1, SCI_VEC, b_x)
out_vec_x = SCI_GET(p_cb_x1, SCI_PEEK_VEC)
itpp_sci_assert( out_vec_x == ref_x, "peek(out_vec) != ref")

out_vec_x = SCI_GET(p_cb_x1, SCI_PEEK_REV_VEC)
itpp_sci_assert( out_vec_x == ref_x[::-1], "peek_reverse(out_vec) != reverse(ref)")

v_x = SCI_GET(p_cb_x1, SCI_SINGLETON)
itpp_sci_assert(v_x == a_x[0], "v_x != a_x[0]")
v_x = SCI_GET(p_cb_x1, SCI_SINGLETON)
itpp_sci_assert(v_x == a_x[1], "v_x != a_x[1]")
v_x = SCI_GET(p_cb_x1, SCI_SINGLETON)
itpp_sci_assert(v_x == a_x[2], "v_x != a_x[2]")

out_vec_x = SCI_GET(p_cb_x1, SCI_VEC);
itpp_sci_assert( out_vec_x == b_x, "out_vec_x != b_x");

out_vec_x = SCI_GET(p_cb_x1, SCI_PEEK_VEC);
itpp_sci_assert( out_vec_x == null_cvec, "out_vec_x != null_cvec");

# process( M cei ticks), gen(N ticks)
cei = np.ndarray(shape=(M), dtype=bool)
ceo = np.ndarray(shape=(M), dtype=bool)
ceio = np.ndarray(shape=(M,2), dtype=bool)
cei[0:M] = True
ceo[0:M] = False
ceio[:,0] = cei
ceio[:,1] = ceo

itpp_sci_assert(SCI_GET(p_cb_x1, SCI_N_OF_ELEM) == 0, "cb1.nrof_elements() != 0")

y_x = SCI_PROC(p_cb_x1, ceio, a_x);

itpp_sci_assert(y_x == np.zeros(M), "y_x == zeros(M)");
itpp_sci_assert(SCI_GET(p_cb_x1, SCI_N_OF_ELEM) == M, "cb1.nrof_elements() != M");

cei = np.ndarray(shape=(N), dtype=bool)
cei[0:N] = True
y_x = SCI_GEN(p_cb_x1, cei);

ref_x = np.ndarray(shape=(N), dtype=complex)
ref_x[0:M] = a_x
ref_x[M:2*M] = a_x
ref_x[2*M:3*M] = a_x
ref_x[3*M] = a_x[0]
itpp_sci_assert(y_x == ref_x, "y_x != ref_x");


if __name__ == '__main__':

    print "sci_circbuff_x1.py"
    print "------------"

