'''
Created on Dec 05, 2015

@author: maki
'''
import numpy    as np
import ctypes   as ct
import copy     as copy
import os, sys

lib_path = os.path.abspath(os.path.join('..', '..', 'lib'))
# scipy_itpp is in lib_path = ..\..\lib
if not(lib_path in sys.path):
    sys.path.append(lib_path)

from scipy_itpp  import *
from scipy_assert  import *

epsilon = 1.0E-6
M = 8
ivx = np.linspace(0, M-1, M) 
cv_ref = np.array([0.7071068+0.0000000j, 0.5000000+0.5000000j, 0.0000000+0.7071068j,-0.5000000+0.5000000j,
                   -0.7071068+0.0000000, -0.5000000-0.5000000j, 0.0000000-0.7071068j, 0.5000000-0.5000000j])
ce = np.ndarray(shape=(M), dtype=bool)
ce[0:M]=True
true_vec = np.ndarray(shape=(M), dtype=bool)
true_vec[0:M]=True

p_mod1 = SCI_CREATE(SCI_PSK_MOD)
sci_type = SCI_GET(p_mod1, SCI_TYPE)
itpp_sci_assert(sci_type == SCI_PSK_MOD, "sci_type != SCI_PSK_MOD")

p_dem1 = SCI_CREATE(SCI_PSK_DEM)
sci_type = SCI_GET(p_dem1, SCI_TYPE)
itpp_sci_assert(sci_type == SCI_PSK_DEM, "sci_type != SCI_PSK_DEM")
SCI_SET(p_mod1, SCI_SIZE, M)
itpp_sci_assert(SCI_GET(p_mod1, SCI_SIZE) == M, "psk_mod1.get_size() != M")

SCI_SET(p_dem1, SCI_SIZE, M)
itpp_sci_assert(SCI_GET(p_dem1, SCI_SIZE) == M, "psk_dem1.get_size() != M")

cv =  SCI_PROC(p_mod1, ce, ivx)
ivy = SCI_PROC(p_dem1, ce, cv)  

itpp_sci_assert(ivy == ivx, "ivy ! =ivx")
itpp_sci_assert((abs(cv - cv_ref) < epsilon) == true_vec, "cv ! =cv_ref")

SCI_DESTROY(p_mod1)
SCI_DESTROY(p_dem1)

if __name__ == '__main__':

    print "sci_psk1.py"
    print "ivx=", ivx
    print "cv=", cv
    print "------------"

