'''
Created on Dec 05, 2015

@author: maki
'''
import numpy    as np
import ctypes   as ct
import copy     as copy
import os, sys

lib_path = os.path.abspath(os.path.join('..', '..', 'lib'))
# scipy_itpp is in lib_path = ..\..\lib
if not(lib_path in sys.path):
    sys.path.append(lib_path)

from scipy_itpp  import *
from scipy_assert  import *

NTAPS = 9


# calculate casual sinc response for nt - normalised fractional time, fixed window - HANNING 
def h_vec(nt):

    TN = (NTAPS - 1)       # normalised impulse response time (N-1)
    dTN = TN / 2;          # casual delay (N-1)/2
    
    # if ((nt < TN) && (nt >= 0.0)) y = sinc_pi(nt - dTN) else 0.0
    y1 = np.sinc((nt - dTN))
    y2 = ((nt >= 0.0) & (nt < TN)).astype(float) 
    y = np.multiply(y1,y2)     
    w = 0.5 * (1.0 - np.cos(2 * np.pi * nt / TN))
    # windowing    
    yw =np.multiply( y , w)
    return yw

N = NTAPS * 2;
TAU = -0.1;
epsilon = 1.0E-6;
 
p_src_x1 = SCI_CREATE(SCI_SRC_X)
sci_type = SCI_GET(p_src_x1, SCI_TYPE)
itpp_sci_assert(sci_type == SCI_SRC_X, "sci_type != SCI_SRC_X")

SCI_SET(p_src_x1, SCI_SIZE, NTAPS)
itpp_sci_assert(SCI_GET(p_src_x1, SCI_SIZE) == NTAPS, "src_x1.get_size() != NTAPS")

t = np.linspace(0, N - 1, N);    # [0,1,2...] normalized sampling time 
t = t + TAU;                  # re-sample time instances

true_vec = np.ndarray(shape=(N), dtype=bool)
true_vec[0:N] = True

cei = np.ndarray(shape=(N), dtype=bool)
ceo = np.ndarray(shape=(N), dtype=bool)
ceio = np.ndarray(shape=(N,2), dtype=bool)
cei[0:N] = True
ceo[0:N] = True
ceio[:,0] = cei
ceio[:,1] = ceo

x_x1 = np.zeros(shape=(N)) + 1j*np.zeros(shape=(N))
x_x1[0] = 1.0+1j*1.0
t_x1 = TAU*np.ones(shape=(N)) + 1j*np.zeros(shape=(N))
xt_x1 = np.ndarray(shape=(N,2), dtype=complex)
xt_x1[:,0] = x_x1
xt_x1[:,1] = t_x1

# get impulse response
y_x1=SCI_PROC(p_src_x1, ceio, xt_x1)
# get reference - casual sinc response for noramlized re-sampling time 
h_ref = h_vec(t)
# both filters should respond with impulse response
y_x1_ref = h_ref +1j* h_ref

itpp_sci_assert((abs(y_x1 - y_x1_ref) < epsilon) == true_vec, "y_x1 != y_x1_ref");



SCI_DESTROY(p_src_x1)

if __name__ == '__main__':

    print "sci_src_x1.py"
    print "y_x1=", y_x1
    print "------------"

