'''
Created on Dec 14, 2015

@author: maki
'''
import numpy    as np
import ctypes   as ct
import copy     as copy
import os, sys

lib_path = os.path.abspath(os.path.join('..', '..', 'lib'))
# scipy_itpp is in lib_path = ..\..\lib
if not(lib_path in sys.path):
    sys.path.append(lib_path)

from scipy_itpp  import *
from scipy_assert  import *

NFFT = 16 # Nfft 
CP = 8 
M = 4  # qpsk
epsilon = 1.0E-6

p_cofdm_mod1 = SCI_CREATE(SCI_COFDM_MOD)
p_cofdm_dem1 = SCI_CREATE(SCI_COFDM_DEM)
p_cofdm_map1 = SCI_CREATE(SCI_COFDM_MAP)
p_cofdm_demap1 = SCI_CREATE(SCI_COFDM_DEMAP)
p_cofdm_sel1 = SCI_CREATE(SCI_COFDM_SEL)

# set modulator
SCI_SET(p_cofdm_mod1, SCI_COFDM_NFFT, NFFT)
SCI_SET(p_cofdm_mod1, SCI_COFDM_CP, CP)
# set demodulator
SCI_SET(p_cofdm_dem1, SCI_COFDM_NFFT, NFFT)
SCI_SET(p_cofdm_dem1, SCI_COFDM_CP, CP)
# set mapper 
SCI_SET(p_cofdm_map1, SCI_COFDM_NFFT, NFFT)
SCI_SET(p_cofdm_map1, SCI_COFDM_QAM_SIZE, M)
# set mapper 
SCI_SET(p_cofdm_demap1, SCI_COFDM_NFFT, NFFT)
SCI_SET(p_cofdm_demap1, SCI_COFDM_QAM_SIZE, M)
# set sel 
SCI_SET(p_cofdm_sel1, SCI_COFDM_NFFT, NFFT)
# z - zero carrier
# p - pilot carrier
# d - data carrier
# 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15
# z p d d d p d d d p d  d  d  p  d  z

dcindx = np.array([ 2, 3, 4, 6, 7, 8, 10, 11, 12, 14 ], dtype=int) 
dc     = np.array([ 0, 1, 2, 3, 0, 1, 2,  3,  0,  1, ], dtype=int)
zcindx = np.array([ 0, 15 ], dtype=int)
pcindx = np.array([ 1, 5, 9, 13 ], dtype=int)
pc     = np.array([ False, True, False, True], dtype=bool)
z_mod  = np.array([0+0*1j, 0+0*1], dtype = complex);
true_vec = np.array([ True, True], dtype=bool)

# set data pilots zero carrier indexes for map
SCI_SET(p_cofdm_map1, SCI_COFDM_DATA_INDEXES, dcindx)
SCI_SET(p_cofdm_map1, SCI_COFDM_PILOT_INDEXES, pcindx)
SCI_SET(p_cofdm_map1, SCI_COFDM_ZERO_INDEXES, zcindx)
# set data pilots zero carrier indexes for demap
SCI_SET(p_cofdm_demap1, SCI_COFDM_DATA_INDEXES, dcindx)
SCI_SET(p_cofdm_demap1, SCI_COFDM_PILOT_INDEXES, pcindx)
SCI_SET(p_cofdm_demap1, SCI_COFDM_ZERO_INDEXES, zcindx)
# set data pilots zero carrier indexes for demap
SCI_SET(p_cofdm_sel1, SCI_COFDM_SEL_INDEXES, zcindx)

# map data/pilots into symbols
SCI_SET(p_cofdm_map1, SCI_COFDM_DATA, dc)
SCI_SET(p_cofdm_map1, SCI_COFDM_PILOTS, pc)
y_map = SCI_GET(p_cofdm_map1, SCI_COFDM_CARRIERS)
# modulate
SCI_SET(p_cofdm_mod1, SCI_COFDM_CARRIERS, y_map)
y_mod = SCI_GET(p_cofdm_mod1, SCI_COFDM_SYMBOL)

# demodulate
SCI_SET(p_cofdm_dem1, SCI_COFDM_SYMBOL, y_mod)
y_dem = SCI_GET(p_cofdm_dem1, SCI_COFDM_CARRIERS)
# demap
SCI_SET(p_cofdm_demap1, SCI_COFDM_CARRIERS, y_dem)
y_demap_data = SCI_GET(p_cofdm_demap1, SCI_COFDM_DATA)
y_demap_pilots = SCI_GET(p_cofdm_demap1, SCI_COFDM_PILOTS)

# select zero carriers
SCI_SET(p_cofdm_sel1, SCI_COFDM_CARRIERS, y_dem)
z_dem = SCI_GET(p_cofdm_sel1, SCI_COFDM_SEL_CARRIERS)

itpp_sci_assert(y_demap_data == dc, "y_demap_data != dc")
itpp_sci_assert(y_demap_pilots == pc, "y_demap_pilots != pc")
itpp_sci_assert((abs(z_dem - z_mod) < epsilon) == true_vec, "z_dem != z_mod")

# test clocked interface with double tick
ce = np.ndarray(shape=(2), dtype=bool) 
ce[0:2] = True;
m_pd0 = np.concatenate(((pc.astype(int))[::-1],dc[::-1]), axis = 1)
m_pd1 = np.concatenate((pc.astype(int),dc), axis = 1)
m_pd = np.vstack((m_pd0,m_pd1))
m_map = SCI_PROC(p_cofdm_map1, ce, m_pd);

itpp_sci_assert((abs((m_map[1,]) - y_map) < epsilon) == np.ones((NFFT),bool), "my_map(1) != y_map");

m_mod = SCI_PROC(p_cofdm_mod1, ce, m_map)
m_dem = SCI_PROC(p_cofdm_dem1, ce, m_mod)
m_pd_dem = SCI_PROC(p_cofdm_demap1, ce, m_dem)

itpp_sci_assert(m_pd_dem == m_pd, "m_pd_dem != m_pd")

if __name__ == '__main__':

    print "sci_codfm1.py"
    print "dc = \n", dc
    print "y_demap_data = \n", y_demap_data
    print "pc = \n", pc
    print "y_demap_pilots = \n", y_demap_pilots
    print "m_pd = \n", m_pd
    print "m_pd_dem = \n", m_pd_dem
    print "------------"

