'''
Created on Dec 16, 2015

@author: maki
'''
import numpy    as np
import ctypes   as ct
import copy     as copy
import os, sys

lib_path = os.path.abspath(os.path.join('..', '..', 'lib'))
# scipy_itpp is in lib_path = ..\..\lib
if not(lib_path in sys.path):
    sys.path.append(lib_path)

from scipy_itpp  import *
from scipy_assert  import *

epsilon = 1.0E-6
M = 8
ivx = np.linspace(0, M-1, M) 
v_ref = np.array([-0.8750000, -0.6250000, -0.3750000, -0.1250000, 0.1250000, 0.3750000, 0.6250000, 0.8750000], dtype=float)
ce = np.ndarray(shape=(M), dtype=bool)
ce[0:M] = True
true_vec = np.ndarray(shape=(M), dtype=bool)
true_vec[0:M] = True

p_mod1 = SCI_CREATE(SCI_PAM_MOD)
sci_type = SCI_GET(p_mod1, SCI_TYPE)
itpp_sci_assert(sci_type == SCI_PAM_MOD, "sci_type != SCI_PAM_MOD")

p_dem1 = SCI_CREATE(SCI_PAM_DEM)
sci_type = SCI_GET(p_dem1, SCI_TYPE)
itpp_sci_assert(sci_type == SCI_PAM_DEM, "sci_type != SCI_PAM_DEM")

SCI_SET(p_mod1, SCI_SIZE, M)
itpp_sci_assert(SCI_GET(p_mod1, SCI_SIZE) == M, "pam_mod1.get_size() != M")

SCI_SET(p_dem1, SCI_SIZE, M)
itpp_sci_assert(SCI_GET(p_dem1, SCI_SIZE) == M, "pam_dem1.get_size() != M")

v =  SCI_PROC(p_mod1, ce, ivx)
ivy = SCI_PROC(p_dem1, ce, v)  

itpp_sci_assert(ivy == ivx, "ivy != ivx")
itpp_sci_assert((abs(v - v_ref) < epsilon) == true_vec, "v ! =v_ref")

SCI_DESTROY(p_mod1)
SCI_DESTROY(p_dem1)

if __name__ == '__main__':

    print "sci_pam1.py"
    print "ivx=", ivx
    print "v=", v
    print "------------"

