'''
Created on Dec 16, 2015

@author: maki
'''
import numpy    as np
import ctypes   as ct
import copy     as copy
import os, sys

lib_path = os.path.abspath(os.path.join('..', '..', 'lib'))
# scipy_itpp is in lib_path = ..\..\lib
if not(lib_path in sys.path):
    sys.path.append(lib_path)

from scipy_itpp  import *
from scipy_assert  import *

epsilon = 1.0E-6

# cascade of 3 stages
CAS_DEC_ORDER = 8
# mav<4>
c0=np.ones(4)*0.25+1j*np.zeros(4)
# 5x the length of impulse response
N=5*(max(c0.shape));
ce = np.ndarray(shape=(N), dtype=bool)
ce[0:N] = True
true_vec = np.ndarray(shape=(N), dtype=bool)
true_vec[0:N] = True;

p_casdec_x1 = SCI_CREATE(SCI_CASDEC_X);
sci_type = SCI_GET(p_casdec_x1, SCI_TYPE);
itpp_sci_assert(sci_type == SCI_CASDEC_X, "sci_type != SCI_CASDEC_X");

p_fir_x1 = SCI_CREATE(SCI_FIR_X);
p_fir_x2 = SCI_CREATE(SCI_FIR_X);
p_fir_x3 = SCI_CREATE(SCI_FIR_X);
p_cnt1 = SCI_CREATE(SCI_COUNTER);
p_cnt2 = SCI_CREATE(SCI_COUNTER);
p_cnt3 = SCI_CREATE(SCI_COUNTER);
p_wgn_x1 = SCI_CREATE(SCI_WGN_X);

# source - random mean = (0.0+j0.0) sigma =1.0
x_x = SCI_GEN(p_wgn_x1, ce);

# discrete cascade settings
SCI_SET(p_fir_x1, SCI_TAPS, c0); 
SCI_EXEC(p_fir_x1, SCI_RESET); 
SCI_SET(p_fir_x2, SCI_TAPS, c0); 
SCI_EXEC(p_fir_x2, SCI_RESET); 
SCI_SET(p_fir_x3, SCI_TAPS, c0); 
SCI_EXEC(p_fir_x3, SCI_RESET); 
SCI_SET(p_cnt1, SCI_PARAM_N, 2); 
SCI_EXEC(p_cnt1, SCI_RESET); 
SCI_SET(p_cnt2, SCI_PARAM_N, 2); 
SCI_EXEC(p_cnt2, SCI_RESET); 
SCI_SET(p_cnt3, SCI_PARAM_N, 2); 
SCI_EXEC(p_cnt3, SCI_RESET); 

# decimator settings
SCI_SET(p_casdec_x1, SCI_ORDER, CAS_DEC_ORDER);
SCI_SET(p_casdec_x1, SCI_TAPS, c0);
SCI_EXEC(p_casdec_x1, SCI_RESET);
    
# discrete cascade proc
ya_x1 = SCI_PROC(p_fir_x1, ce, x_x); 
ce1 = SCI_GEN(p_cnt1, ce);
ya_x2 = SCI_PROC(p_fir_x2, ce1, ya_x1); 
ce2 = SCI_GEN(p_cnt2, ce1);
ya_x3 = SCI_PROC(p_fir_x3, ce2, ya_x2); 
ce3 = SCI_GEN(p_cnt3, ce2);
ya = np.ndarray(shape=(N,2), dtype=complex)
ya[:,0] = ya_x3
ya[:,1] = ((ce3.transpose()).astype(float) + 1j*np.zeros(N))[:]

# decimator proc 
yb = SCI_PROC(p_casdec_x1, ce, x_x);

itpp_sci_assert((abs(yb[:,0] - ya[:,0]) < epsilon) == true_vec, "yb(:,0) ! = ya(:,0)");
itpp_sci_assert((yb[:,1].real).astype(bool) == (ya[:,1].real).astype(bool), "yb(:,1) ! = ya(:,1)");

SCI_DESTROY(p_casdec_x1);

SCI_DESTROY(p_fir_x1);
SCI_DESTROY(p_fir_x2); 
SCI_DESTROY(p_fir_x3);
SCI_DESTROY(p_cnt1); 
SCI_DESTROY(p_cnt2); 
SCI_DESTROY(p_cnt3);

SCI_DESTROY(p_wgn_x1);

if __name__ == '__main__':

    print "sci_casdec_x1.py"
    yc = np.ndarray(shape=(N,4), dtype=complex)
    yc[:,0] = ya[:,0]
    yc[:,1] = yb[:,0]
    yc[:,2] = ya[:,1]
    yc[:,3] = yb[:,1]
    np.set_printoptions(linewidth = 120, precision = 5)
    print "yc= \n", yc
    print "------------"

