'''
Created on Dec 20, 2015

@author: maki
'''
import numpy    as np
import ctypes   as ct
import copy     as copy

import os, sys
# scipy_itpp is in lib_path = ..\..\lib
lib_path = os.path.abspath(os.path.join('..', '..', 'lib'))
if not(lib_path in sys.path):
    sys.path.append(lib_path)

from scipy_itpp  import *   
from scipy_assert  import *

W = 8   # input symbols width = bytes 
N = 4   # number of input symbols

WA = 4   # testA output symbols width 
WB = 16  # testB output symbols width

NA = int((N * W) / WA)       # process NA symbols of WA width
NB = int((2 * N * W) / WB)   # generate NB symbols of WB width

x1 = np.array([[1, 1, 1, 1, 0, 0, 0, 0], [1, 1, 1, 1, 0, 0, 0, 1], [1, 1, 1, 1, 0, 0, 1, 0], [1, 1, 1, 1, 0, 0, 1, 1]], dtype = bool)
yA_ref = np.array([[1, 1, 1, 1], [0, 0, 0, 0], [1, 1, 1, 1], [0, 0, 0, 1], [1, 1, 1, 1], [0, 0, 1, 0], [1, 1, 1, 1], [0, 0, 1, 1]], dtype = bool)
yB_ref = np.array([[1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1], [1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 0, 0, 1, 1],
                   [1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1], [1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 0, 0, 1, 1]], dtype = bool)

p_bb1 = SCI_CREATE(SCI_BINBUFF)
sci_type = SCI_GET(p_bb1, SCI_TYPE)
itpp_sci_assert(sci_type == SCI_BINBUFF, "sci_type != SCI_BINBUFF")

# buffer size in bits
SCI_SET(p_bb1, SCI_SIZE, W * N)
# symbols symbol_size
SCI_SET(p_bb1, SCI_SYMBOL_SIZE, W)


#[ceio]=[1|0]
ceio = np.ndarray(shape=(N,2), dtype=bool)
ce1 = np.ndarray(shape=(N), dtype=bool)
ce0 = np.ndarray(shape=(N), dtype=bool)
ce1[0:N] = True
ce0[0:N] = False
# push in all N bytes - ceio=[cei|cei] = [1|0] - filling -up - ceo=0
ceio[:,0] = ce1
ceio[:,1] = ce0
SCI_PROC(p_bb1, ceio, x1);
itpp_sci_assert(SCI_GET(p_bb1, SCI_N_OF_ELEM) == N*W, "nrof_elements() != N*W");

# pop in all NA symbols of WA width by processing with cei=0 - empting the buffer 
# ceio[NA,:]=[0,1]
ceio = np.ndarray(shape=(NA,2), dtype=bool)
ce1 = np.ndarray(shape=(NA), dtype=bool)
ce0 = np.ndarray(shape=(NA), dtype=bool)
ce1[0:NA] = True
ce0[0:NA] = False
ceio[:,0] = ce0
ceio[:,1] = ce1
SCI_SET(p_bb1, SCI_SYMBOL_SIZE, WA)
yA = SCI_PROC(p_bb1, ceio, ceio)
itpp_sci_assert(yA == yA_ref, "yA != yA_ref")
itpp_sci_assert(SCI_GET(p_bb1, SCI_N_OF_ELEM) == 0, "nrof_elements() != 0")
 
# put resized data - generate new symbols
ce1 = np.ndarray(shape=(NB), dtype=bool)
ce1[:] = True
SCI_SET(p_bb1, SCI_VEC, x1.flatten());
itpp_sci_assert(SCI_GET(p_bb1, SCI_N_OF_ELEM) == N*W, "nrof_elements() != N*W");
 
SCI_SET(p_bb1, SCI_SYMBOL_SIZE, WB);
yB = SCI_GEN(p_bb1, ce1);
itpp_sci_assert(yB == yB_ref, "yB != yB_ref");
itpp_sci_assert(SCI_GET(p_bb1, SCI_N_OF_ELEM) == N*W, "nrof_elements() != N*W");

SCI_DESTROY(p_bb1);

if __name__ == '__main__':
    
    print "sci_binbuff.py"
    print "yA= \n", yA.astype(int)
    print "yB= \n", yB.astype(int)
    print "------------"