'''
Created on Dec 21, 2015

@author: maki
'''
import numpy    as np
import ctypes   as ct
import copy     as copy
import os, sys

lib_path = os.path.abspath(os.path.join('..', '..', 'lib'))
# scipy_itpp is in lib_path = ..\..\lib
if not(lib_path in sys.path):
    sys.path.append(lib_path)

from scipy_itpp  import *
from scipy_assert  import *

epsilon = 1.0E-6

x_x = np.ndarray(shape=(3), dtype=complex)
true_vec = np.ndarray(shape=(3), dtype=bool)
true_vec[0:3]=True

p_tedg_x1 = SCI_CREATE(SCI_TEDG_X)
sci_type = SCI_GET(p_tedg_x1, SCI_TYPE)
itpp_sci_assert(sci_type == SCI_TEDG_X, "sci_type != SCI_TEDG_X")

SCI_SET(p_tedg_x1, SCI_MODE, TEDG_MODE_STD)
itpp_sci_assert(SCI_GET(p_tedg_x1, SCI_MODE) == TEDG_MODE_STD, "mode != TEDG_MODE_STD")

# ceio[cei|ceo]
ceio = np.array([[1, 1], [1, 0], [1, 1]], dtype = bool)

# perfect timing for triangle waveform
x = np.array([1.0, 0.0, -1.0], dtype=float)
x_x = x + x*1j
y_x_ref = np.array([0.000+0.000*1j, 0.000+0.000*1j, 0.000+0.000*1j], dtype = complex);
y_x = SCI_PROC(p_tedg_x1, ceio, x_x);
itpp_sci_assert((abs(y_x - y_x_ref) < epsilon) == true_vec, "y_x != y_x_ref");

# late timing for triangle waveform
x = np.array([0.5, -0.5, -0.5], dtype=float)
x_x = x + x*1j
y_x_ref = np.array([-0.500-0.500*1j, -0.500-0.500*1j, 0.500+0.500*1j], dtype = complex);
y_x = SCI_PROC(p_tedg_x1, ceio, x_x);
itpp_sci_assert((abs(y_x - y_x_ref) < epsilon) == true_vec, "y_x != y_x_ref");

# early timing for triangle waveform
x = np.array([0.5, 0.5, -0.5], dtype=float)
x_x = x + x*1j
y_x_ref = np.array([-0.500-0.500*1j, -0.500-0.500*1j, -0.500-0.500*1j], dtype = complex);
y_x = SCI_PROC(p_tedg_x1, ceio, x_x);
itpp_sci_assert((abs(y_x - y_x_ref) < epsilon) == true_vec, "y_x != y_x_ref");

SCI_DESTROY(p_tedg_x1)

if __name__ == '__main__':

    print "sci_tedg_x.py"
    print "x_x = \n", x_x
    print "y_x = \n", x_x
    print "------------"

